#pragma once

#include "buffer.h"

#include <string.h>
#include <stdbool.h>

typedef enum {
    UNKOWN,
    A,      // 1
    NS,     // 2
    CNAME,  // 5
    SOA,    // 6
    PTR,    // 12
    MX,     // 15
    TXT,    // 16
    AAAA,   // 28
    SRV,    // 33
    CAA    // 257
} RecordType;

uint16_t record_to_id(RecordType type);
void record_from_id(uint16_t i, RecordType* type);

typedef struct {
    uint8_t addr[4];
} ARecord;

typedef struct {
    uint8_t* host;
} NSRecord;

typedef struct {
    uint8_t* host;
} CNAMERecord;

typedef struct {
    uint8_t* mname;
    uint8_t* nname;
    uint32_t serial;
    uint32_t refresh;
    uint32_t retry;
    uint32_t expire;
    uint32_t minimum;
} SOARecord;

typedef struct {
    uint8_t* pointer;
} PTRRecord;

typedef struct {
    uint16_t priority;
    uint8_t* host;
} MXRecord;

typedef struct TXTRecord {
    uint8_t** text;
    uint8_t len;
} TXTRecord;

typedef struct {
    uint8_t addr[16];
} AAAARecord;

typedef struct {
    uint16_t priority;
    uint16_t weight;
    uint16_t port;
    uint8_t* target;
} SRVRecord;

typedef struct {
    uint8_t flags;
    uint8_t length;
    uint8_t* tag;
    uint8_t* value;
} CAARecord;

typedef struct {
    char* command;
} CMDRecord;

typedef struct {
    uint32_t ttl;
    uint16_t cls;
    uint16_t len;
    uint8_t* domain;
    RecordType type;
    union data {
        ARecord a;
        NSRecord ns;
        CNAMERecord cname;
        SOARecord soa;
        PTRRecord ptr;
        MXRecord mx;
        TXTRecord txt;
        AAAARecord aaaa;
        SRVRecord srv;
        CAARecord caa;
        CMDRecord cmd;
    } data;
} Record;

bool read_record(PacketBuffer* buffer, Record* record);
void write_record(PacketBuffer* buffer, Record* record);
void free_record(Record* record);
void print_record(Record* record);
bool str_to_qtype(const char* str, RecordType* type);
