#pragma once

#include "buffer.h"
#include "record.h"

typedef struct {
    uint8_t* domain;
    RecordType qtype;
    uint16_t cls;
} Question;

void create_question(const char* domain, RecordType qtype, Question* question);
bool read_question(PacketBuffer* buffer, Question* question);
void write_question(PacketBuffer* buffer, Question* question);
void free_question(Question* question);
void print_question(Question* question);
