#pragma once

#include "buffer.h"
#include "question.h"
#include "header.h"
#include "record.h"
#include "../client/addr.h"

#include <stdbool.h>

typedef struct {
    Header header;
    Question* questions;
    Record* answers;
    Record* authorities;
    Record* resources;
} Packet;

void read_packet(PacketBuffer* buffer, Packet* packet);
void write_packet(PacketBuffer* buffer, Packet* packet);
void free_packet(Packet* packet);

bool get_random_a(Packet* packet, IpAddr* addr);
bool get_resolved_ns(Packet* packet, uint8_t* qname, IpAddr* addr);
bool get_unresoled_ns(Packet* packet, uint8_t* qname, Question* question);
