#pragma once

#include "buffer.h"

#include <stdbool.h>

typedef enum {
    NOERROR,    // 0
    FORMERR,    // 1
    SERVFAIL,   // 2
    NXDOMAIN,   // 3,
    NOTIMP,     // 4
    REFUSED,    // 5
} ResultCode;

uint8_t rescode_to_id(ResultCode code);
ResultCode rescode_from_id(uint8_t id);

typedef struct {
    uint16_t id;

    bool recursion_desired;     // 1 bit
    bool truncated_message;     // 1 bit
    bool authorative_answer;    // 1 bit
    uint8_t opcode;               // 4 bits
    bool response;              // 1 bit

    ResultCode rescode;         // 4 bits
    bool checking_disabled;     // 1 bit
    bool authed_data;           // 1 bit
    bool z;                     // 1 bit
    bool recursion_available;   // 1 bit

    uint16_t questions;               // 16 bits
    uint16_t answers;                 // 16 bits
    uint16_t authoritative_entries;   // 16 bits
    uint16_t resource_entries;        // 16 bits
} Header;

void read_header(PacketBuffer* buffer, Header* header);
void write_header(PacketBuffer* buffer, Header* header);
const char* str_from_code(ResultCode code);
