#pragma once

#include <stdint.h>

typedef struct PacketBuffer PacketBuffer;

PacketBuffer* buffer_create(int capacity);

void buffer_free(PacketBuffer* buffer);

void buffer_seek(PacketBuffer* buffer, int index);

uint8_t buffer_read(PacketBuffer* buffer);

uint16_t buffer_read_short(PacketBuffer* buffer);

uint32_t buffer_read_int(PacketBuffer* buffer);

uint8_t buffer_get(PacketBuffer* buffer, int index);

uint8_t* buffer_get_range(PacketBuffer* buffer, int start, int len);

uint16_t buffer_get_size(PacketBuffer* buffer);

void buffer_read_qname(PacketBuffer* buffer, uint8_t** out);

void buffer_read_string(PacketBuffer* buffer, uint8_t** out);

void buffer_read_n(PacketBuffer* buffer, uint8_t** out, uint8_t len);

void buffer_write(PacketBuffer* buffer, uint8_t data);

void buffer_write_short(PacketBuffer* buffer, uint16_t data);

void buffer_write_int(PacketBuffer* buffer, uint32_t data);

void buffer_write_qname(PacketBuffer* buffer, uint8_t* in);

void buffer_write_string(PacketBuffer* buffer, uint8_t* in);

void buffer_write_n(PacketBuffer* buffer, uint8_t* in, int len);

void buffer_set(PacketBuffer* buffer, uint8_t data, int index);

void buffer_set_uint16_t(PacketBuffer* buffer, uint16_t data, int index);

int buffer_get_index(PacketBuffer* buffer);

void buffer_step(PacketBuffer* buffer, int len);

uint8_t* buffer_get_ptr(PacketBuffer* buffer);
