#include "client/addr.h"
#include "client/client.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/select.h>

#define DEFAULT_PORT 53

static void help() {
    printf("wig: a simple dns client\n");
    printf("usage: wig [@server] [options] domain [qtype]\n");
    printf("arguments: \n");
    printf("\t@server\t specify a dns server (@example.com)\n");
    printf("\t-p\t specify a port (-p 2000)\n");
    printf("\t-t\t force dns request to do tcp first\n");
    exit(EXIT_SUCCESS);
}

static void parse_server (char* argv, char** server) {
    if (*server != NULL) {
        printf("error: only one dns server argument is allowed\n");
        exit(EXIT_FAILURE);
    }
    if (strlen(argv) < 1) {
        printf("error: dns server argument cannot be empty\n");
        exit(EXIT_FAILURE);
    }
    *server = argv;
}

static int parse_arguent (int argc, char** argv, Options* options) {
    if (strlen(argv[0]) < 2) {
        printf("error: expected option after -\n");
        exit(EXIT_FAILURE);
    }

    if (strcmp(argv[0], "-p") == 0) {
        if (argc < 2) {
            printf("error: expected port after -p\n");
            exit(EXIT_FAILURE);
        }
        if ((options->port = strtoul(argv[1], NULL, 10)) == 0) {
            printf("error: %s is not a valid port\n", argv[1]);
            exit(EXIT_FAILURE);
        }
        return 1;
    } else if (strcmp(argv[0], "-t") == 0) {
        options->force_tcp = true;
        return 0;
    } else if (
        strcmp(argv[0], "-h") == 0 ||
        strcmp(argv[0], "--help") == 0
    ) {
        help();
    }

    printf("error: unkown option %s\n", argv[0]);
    exit(EXIT_FAILURE);
}

int main(int argc, char** argv) {

    if (argc < 1) return EXIT_FAILURE;

    int dargs = 1;
   
    char* server = NULL;
    Options options;
    options.port = DEFAULT_PORT;
    options.force_tcp = false;
    
    for (int i = 1; i < argc; i++) {
        char s = argv[i][0];
        if (s == '@') {
            dargs++;
            parse_server(argv[i] + 1, &server);
        } else if (s == '-') {
            int o = parse_arguent(argc - i, &argv[i], &options);
            dargs++;
            dargs += o;
            i += o;
        } else {
            break;
        }
    }

    if (argc - dargs < 1) {
        printf("usage: wig [@server] [options] domain [qtype]\n");
        return EXIT_FAILURE;
    }

    IpAddr addr;

    if (server != NULL) {
        if (!ip_addr_name(server, &addr)) {
            printf("error: %s is not a valid domain\n", server);
            exit(EXIT_FAILURE);
        } 
    } else {
        resolve_default_server(&addr);
    }

    Question* arr;
    uint8_t len;

    resolve_questions(argc - dargs, &argv[dargs], &len, &arr);
    resolve(addr, options, arr, len);

    return EXIT_SUCCESS;
}
