#pragma once

#include "../packet/packet.h"
#include "addr.h"

#include <netinet/in.h>

typedef enum {
    UDP,
    TCP
} BindingType;

typedef struct {
    BindingType type;
    union {
        struct {
            UdpSocket udp;
            SocketAddr clientaddr;
        } udp;
        TcpStream tcp;
    } sock;
} Connection;

bool create_request(BindingType type, SocketAddr* addr, Connection* request);
bool request_packet(Connection* request, Packet* in, Packet* out);
void free_request(Connection* connection);
