#pragma once

#include "../packet/record.h"

#include <string.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/types.h>

typedef enum {
    V4,
    V6
} AddrType;

typedef struct {
    AddrType type;
    union {
        struct in_addr v4;
        struct in6_addr v6;
    } data;
} IpAddr;

void create_ip_addr(uint8_t* domain, IpAddr* addr);
void create_ip_addr6(uint8_t* domain, IpAddr* addr);
void ip_addr_any(IpAddr* addr);
void ip_addr_any6(IpAddr* addr);
bool ip_addr_name(const char* name, IpAddr* addr);

typedef struct {
    AddrType type;
    union {
        struct sockaddr_in v4;
        struct sockaddr_in6 v6;
    } data;
    size_t len;
} SocketAddr;

void create_socket_addr(uint16_t port, IpAddr addr, SocketAddr* socket);

typedef struct {
    AddrType type;
    uint32_t sockfd;
} UdpSocket;

int32_t create_udp_socket(AddrType type, UdpSocket* socket);
int32_t bind_udp_socket(SocketAddr* addr, UdpSocket* socket);
int32_t read_udp_socket(UdpSocket* socket, void* buffer, uint16_t len, SocketAddr* clientaddr);
int32_t write_udp_socket(UdpSocket* socket, void* buffer, uint16_t len, SocketAddr* clientaddr);
int32_t close_udp_socket(UdpSocket* socket);

typedef struct {
    AddrType type;
    uint32_t sockfd;
} TcpSocket;

typedef struct {
    SocketAddr clientaddr;
    uint32_t streamfd;
} TcpStream;

int32_t create_tcp_socket(AddrType type, TcpSocket* socket);
int32_t bind_tcp_socket(SocketAddr* addr, TcpSocket* socket);
int32_t listen_tcp_socket(TcpSocket* socket, uint32_t max);
int32_t accept_tcp_socket(TcpSocket* socket, TcpStream* stream);
int32_t close_tcp_socket(TcpSocket* socket);
int32_t connect_tcp_stream(SocketAddr* servaddr, TcpStream* stream);
int32_t read_tcp_stream(TcpStream* stream, void* buffer, uint16_t len);
int32_t write_tcp_stream(TcpStream* stream, void* buffer, uint16_t len);
int32_t close_tcp_stream(TcpStream* stream);
