#include "pic.h"
#include "io.h"

void config_pic(uint8_t pic1_offset, uint8_t pic2_offset) {
    char a1 = inb(PIC1_DATA_PORT);
    char a2 = inb(PIC2_DATA_PORT);
    // control word 1
    // 0x11: initialize, enable ICW4
    outb(PIC1_COMMAND_PORT, 0x11);
    iowait();
    outb(PIC2_COMMAND_PORT, 0x11);
    iowait();
    // control word 2
    // interrupt offset
    outb(PIC1_DATA_PORT, pic1_offset);
    iowait();
    outb(PIC2_DATA_PORT, pic2_offset);
    iowait();
    // control word 3
    // primary pic: set which pin secondary is connected to
    // (pin 2)
    outb(PIC1_DATA_PORT, 0b00000100);
    iowait();
    outb(PIC2_DATA_PORT, 2);
    iowait();
    // control word 3
    // 0x01: enable 8086 mode
    outb(PIC1_DATA_PORT, 0x01);
    iowait();
    outb(PIC2_DATA_PORT, 0x01);
    iowait();
    // clear data registers
    outb(PIC1_DATA_PORT, a1);
    outb(PIC2_DATA_PORT, a2);
}

void pic_mask(int irq) {
    uint8_t port;
    if(irq < 8) {
        port = PIC1_DATA_PORT;
    } else {
        irq -= 8;
        port = PIC2_DATA_PORT;
    }
    uint8_t mask = inb(port);
    outb(port, mask | (1 << irq));
}

void pic_unmask(int irq) {
    uint8_t port;
    if(irq < 8) {
        port = PIC1_DATA_PORT;
    } else {
        irq -= 8;
        port = PIC2_DATA_PORT;
    }
    uint8_t mask = inb(port);
    outb(port, mask & ~(1 << irq));
}

// completely disable the PIC
void pic_disable() {
    outb(PIC1_DATA_PORT, 0xff);
    iowait();
    outb(PIC2_DATA_PORT, 0xff);
    iowait();
}

// end of interrupt
void pic_eoi(int irq) {
    if(irq >= 8) {
        outb(PIC2_COMMAND_PORT, 0x20);
    }
    outb(PIC1_COMMAND_PORT, 0x20);
}
