[extern idt_exception_handler]
[extern idt_pic_timer]
[extern idt_pic_keyboard]
[extern idt_pic_handler]
[extern isr_stub_table]

%macro ISRErrorStub 1
ISRStub%+%1:
    push dword %1
    call idt_exception_handler
    pop eax
    iret 
%endmacro

%macro PICTimer 1
ISRStub%+%1:
    push dword %1
    call idt_pic_timer
    pop eax
    iret
%endmacro

%macro PICKeyboard 1
ISRStub%+%1:
    push dword %1
    call idt_pic_keyboard
    pop eax
    iret
%endmacro


%macro PICInterrupt 1
ISRStub%+%1:
    push dword %1
    call idt_pic_handler
    pop eax
    iret
%endmacro

ISRErrorStub 0
ISRErrorStub 1
ISRErrorStub 2
ISRErrorStub 3
ISRErrorStub 4
ISRErrorStub 5
ISRErrorStub 6
ISRErrorStub 7
ISRErrorStub 8
ISRErrorStub 9
ISRErrorStub 10
ISRErrorStub 11
ISRErrorStub 12
ISRErrorStub 13
ISRErrorStub 14
ISRErrorStub 15
ISRErrorStub 16
ISRErrorStub 17
ISRErrorStub 18
ISRErrorStub 19
ISRErrorStub 20
ISRErrorStub 21
ISRErrorStub 22
ISRErrorStub 23
ISRErrorStub 24
ISRErrorStub 25
ISRErrorStub 26
ISRErrorStub 27
ISRErrorStub 28
ISRErrorStub 29
ISRErrorStub 30
ISRErrorStub 31
PICTimer     32
PICKeyboard  33
PICInterrupt 34
PICInterrupt 35
PICInterrupt 36
PICInterrupt 37
PICInterrupt 38
PICInterrupt 39
PICInterrupt 40
PICInterrupt 41
PICInterrupt 42
PICInterrupt 43
PICInterrupt 44
PICInterrupt 45
PICInterrupt 46
PICInterrupt 47

[global ISRStubTable]
isr_stub_table:
%assign i 0 
%rep    48
    dd ISRStub%+i 
%assign i i+1 
%endrep
