#include "io.h"

void outb(uint16_t port, uint8_t val) {
    __asm__ volatile ( 
        "outb %0, %1" : : "a"(val), "Nd"(port) 
    );
}

uint8_t inb(uint16_t port) {
    uint8_t result;
    __asm__ volatile (
        "inb %1, %0" : "=a"(result) : "Nd"(port) 
    );
    return result;
}

void iowait() {
    outb(UNUSED_PORT, 0);
}

void enable_interrupts() {
    __asm__ volatile ("sti");
}

void disable_interrupts() {
    __asm__ volatile ("cli");
}

void halt() {
    __asm__ volatile ("hlt");
}
