#pragma once
#include <stdint.h> 

#define IDT_SIZE 256
#define IDT_INTERRUPTS 48

typedef struct {
    uint16_t isr_low; // low 16 bits of ISR's address
    uint16_t kernel_code_selector; // GDT segment to load
    uint8_t reserved;
    uint8_t attributes;
    uint16_t isr_high; // high 16 bits
} __attribute__((packed)) IDTEntry;

typedef struct {
	uint16_t	limit;
	uint32_t	base;
} __attribute__((packed)) IDTRegister;

typedef enum {
    IDT_FLAG_GATE_TASK = 0x5,
    IDT_FLAG_GATE_16BIT_INT = 0x6,
    IDT_FLAG_GATE_16BIT_TRAP = 0x7,
    IDT_FLAG_GATE_32BIT_INT = 0xE,
    IDT_FLAG_GATE_32BIT_TRAP = 0xF,

    IDT_FLAG_RING0 = (0 << 5),
    IDT_FLAG_RING1 = (1 << 5),
    IDT_FLAG_RING2 = (2 << 5),
    IDT_FLAG_RING3 = (3 << 5),

    IDT_FLAG_PRESENT = 0x80,
    
} IDTFlags;

#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-variable"

__attribute__((aligned(0x10))) 
static IDTEntry idt[256];

static IDTRegister idtr;

#pragma GCC diagnostic pop

void idt_pic_timer(uint8_t exception);

void idt_pic_keyboard(uint8_t exception);

void idt_pic_handler(uint8_t exception);

void idt_exception_handler(uint8_t);

void idt_set_descriptor(uint8_t vector, void* isr, uint8_t flags);

extern void* isr_stub_table[];
 
void idt_init(void);
