#include "util.h"
#include <stdint.h>

uint8_t hex2i(char hex) {
    if(hex < 'A') {
        return hex - '0';
    } else if(hex < 'a') {
        return hex - 'A' + 10;
    } else {
        return hex - 'a' + 10;
    }
}

char* itoa(int value, char* str, int base) {
    if(base < 2 || base > 36) {
        *str = '\0';
        return str;
    }
    if(value < 0) {
        *str = '-';
        str++;
        value = -value;
    }
    char* ptr = str;
    char* nbegin = str; // where the number starts
    while(1) {
        *ptr = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"[value % base];
        ptr++;
        value /= base;
        if(value == 0) {
            break;
        }
    }
    *ptr = '\0';
    ptr--;
    // invert string
    while(nbegin < ptr) {
        char tmp = *nbegin;
        *nbegin = *ptr;
        *ptr = tmp;
        ptr--;
        nbegin++;
    }
    return str;
}
