#include "string.h"

void memcpy(void* dest, const void* src, size_t n) {
    const char* s = src;
    char* d = dest;
    for(int i = 0; i < n; i++) {
        *d++ = *s++;
    }
}

void memset(void* dest, char value, size_t n) {
    char* d = dest;
    for(int i = 0; i < n; i++) {
        *d++ = value;
    }
}

void strcpy(char* dest, const char* src) {
    while(*src != '\0') {
        *dest++ = *src++;
    }
}

size_t strlen(const char* str) {
    size_t len = 0;
    while(*str != '\0') {
        len += 1;
        str++;
    }
    return len;
}

void strcat(char* dest, const char* src) {
    while(*dest != '\0') {
        dest++;
    }
    const char* s = src;
    while(*s != '\0') {
        *dest++ = *s++;
    }
    *dest = '\0';
}
