#pragma once
#include <stdarg.h>
#include <stddef.h>

#define VGA_VIDEO_MEMORY (size_t)0xb8000

#define SCREEN_WIDTH 80
#define SCREEN_HEIGHT 25

#define F_BLACK 0x00
#define F_BLUE 0x01
#define F_GREEN 0x02
#define F_CYAN 0x03
#define F_RED 0x04
#define F_MAGENTA 0x05
#define F_YELLOW 0x06
#define F_WHITE 0x07

#define B_BLACK 0x00
#define B_BLUE 0x10
#define B_GREEN 0x20
#define B_CYAN 0x30
#define B_RED 0x40
#define B_MAGENTA 0x50
#define B_YELLOW 0x60
#define B_WHITE 0x70

#define F_BRIGHT 0x08
#define B_BRIGHT 0x80

size_t screenaddr(int x, int y);

void writec(int x, int y, char c, char color);
void write(int x, int y, const char* str, char color);

void scroll(int lines);
void clearline(int line);
void clearscreen(void);

void nextline(void);
void setcol(char col);
void resetcol(void);

void putc(char c);
void print(const char* str);
void println(const char* str);
void printfv(const char* str, va_list args);
void printf(const char* str, ...);
void printfln(const char* str, ...);
