#pragma once
#include <stddef.h>
#include <stdbool.h>

typedef struct _HeapBlock {
    struct _HeapBlock* prev; // pointer to previous block
    struct _HeapBlock* next; // pointer to next block
    bool used; // 1 if used, 0 if free
    size_t size; // size of data after block
    char* tag; // tag
    
} HeapBlock;

typedef struct {
    HeapBlock* first; // the first heap block
} Heap;

void init_heap(Heap* h, size_t base, size_t size);

void* alloc(Heap* h, size_t size);
void free(void* ptr);
void* realloc(Heap* h, void* ptr, size_t size);

char* hgettag(void* ptr);
void hsettag(void* ptr, char* tag);
void heaptrace(Heap* h);


