#include "keyboard.h"
#include <stdint.h>
#include <stdbool.h>

#define KEYCODE_L_SHIFT 0x2A
#define KEYCODE_R_SHIFT 0x36
#define KEYCODE_CTRL 0x1D // r = extended
#define KEYCODE_ALT 0x38 // r = extended

const char keymap[128] = {
    '\0', '\0',  '1',  '2',  '3',  '4',  '5',  '6',
     '7',  '8',  '9',  '0',  '-',  '=', '\0', '\t',
     'q',  'w',  'e',  'r',  't',  'y',  'u',  'i',
     'o',  'p',  '[',  ']', '\n', '\0',  'a',  's',
     'd',  'f',  'g',  'h',  'j',  'k',  'l',  ';',
    '\'',  '`', '\0', '\\',  'z',  'x',  'c',  'v',
     'b',  'n',  'm',  ',',  '.',  '/', '\0',  '*',
    '\0',  ' ', '\0', '\0', '\0', '\0', '\0', '\0',
    '\0', '\0', '\0', '\0', '\0', '\0', '\0',  '7',
     '8',  '9',  '-',  '4',  '5',  '6',  '+',  '1',
     '2',  '3',  '0',  '.', // rest is filled with 0
};

const char keymap_shift[128] = {
    '\0', '\0',  '!',  '@',  '#',  '$',  '%',  '^',
     '&',  '*',  '(',  ')',  '_',  '+', '\0', '\0',
     'Q',  'W',  'E',  'R',  'T',  'Y',  'U',  'I',
     'O',  'P',  '{',  '}', '\n', '\0',  'A',  'S',
     'D',  'F',  'G',  'H',  'J',  'K',  'L',  ':',
     '"',  '~', '\0',  '|',  'Z',  'X',  'C',  'V',
     'B',  'N',  'M',  '<',  '>',  '?', '\0',  '*',
    '\0',  ' ', '\0', '\0', '\0', '\0', '\0', '\0',
    '\0', '\0', '\0', '\0', '\0', '\0', '\0',  '7',
     '8',  '9',  '-',  '4',  '5',  '6',  '+',  '1',
     '2',  '3',  '0',  '.', // rest is filled with 0
};

bool enabled = false;

bool next_extended = false;

bool mod_l_shift = false;
bool mod_r_shift = false;
bool mod_l_ctrl = false;
bool mod_r_ctrl = false;
bool mod_l_alt = false;
bool mod_r_alt = false;

bool haschar = false;
char nextchar = '\0';

bool haskey = false;
uint16_t nextkey = 0;

void kbd_enable() {
    enabled = true;
}

void kbd_disable() {
    enabled = false;
    haschar = false;
    haskey = false;
}

void set_next_extended() {
    next_extended = true;
}

void process_keycode(uint8_t code, bool release) {
    if(!enabled) return;
    haskey = true;
    nextkey = ((uint16_t)next_extended << 8) | ((uint16_t)release << 12) | (uint16_t)code;
    if(next_extended) {
        next_extended = false;
        if(code == KEYCODE_ALT) {
            mod_r_alt = !release;
        } else if(code == KEYCODE_CTRL) {
            mod_r_ctrl = !release;
        }
    } else {
        if(code == KEYCODE_L_SHIFT) {
            mod_l_shift = !release;
        } else if(code == KEYCODE_R_SHIFT) {
            mod_r_shift = !release;
        } else if(code == KEYCODE_ALT) {
            mod_l_alt = !release;
        } else if(code == KEYCODE_CTRL) {
            mod_l_ctrl = !release;
        } else if(!release) {
            if(mod_l_ctrl | mod_r_ctrl | mod_l_alt | mod_r_alt) {
                return;
            }
            char c;
            if(mod_l_shift | mod_r_shift) {
                c = keymap_shift[code];
            } else {
                c = keymap[code];
            }
            if(c != '\0') {
                haschar = true;
                nextchar = c;
            }
        }
    }
}
