#include "sys/io.h"
#include "lib/memory.h"
#include "panic.h"
#include "sys/pic.h"
#include "lib/stdio.h"
#include "sys/idt.h"
#include "keyboard.h"

void heaptest(Heap* heap) {
    void* ptr1_1 = alloc(heap, 10);
    println("ptr1_1 success");
    void* ptr2 = alloc(heap, 20);
    void* ptr1_2 = realloc(heap, ptr1_1, 5);
    println("ptr1_2 success");
    void* ptr1_3 = realloc(heap, ptr1_2, 20);
    println("ptr1_3 success");

    heaptrace(heap);
}


extern int main(void) {
    println("Loaded kernel");
    idt_init();
    println("Initialized IDT");
    config_pic(PIC_REMAP_OFFSET, PIC_REMAP_OFFSET + 8);
    enable_interrupts();
    println("Configured PIC");
    outb(0x60, 0xF4);
    println("Enabled keyboard interrupts");

    Heap* heap;
    init_heap(heap, 0x1000000, 0x1000000);
    println("Initialized heap");
    printfln("Heap block size: 0x%x", sizeof(HeapBlock));

    heaptest(heap);

    kbd_enable();
    while(1) {
        halt();
        if(haschar) {
            putc(nextchar);
            haschar = false;
        }
    }

    __asm__ volatile ("cli; hlt");
    return 0;
}
