[org 0x7c00] ; begin at 0x7c00
KERNEL_LOC equ 0x1000
CODE_SEG equ code_descriptor - GDT_Start
DATA_SEG equ data_descriptor - GDT_Start

mov [boot_disk], dl

; set up registers and stack
xor ax, ax
mov es, ax
mov ds, ax
mov bp, 0x8000
mov sp, bp

; read disk
mov bx, KERNEL_LOC ; target memory location
mov ah, 2
mov al, 40 ; # of sectors to read
mov ch, 0 ; cylinder number
mov dh, 0 ; head number
mov cl, 2 ; sector number
mov dl, [boot_disk]
int 0x13

; text mode (clear screen)
mov ah, 0
mov al, 3
int 0x10

; protected mode
cli
lgdt [GDT_Descriptor]
mov eax, cr0
or eax, 1
mov cr0, eax
; far jump
jmp CODE_SEG:start_protected_mode
jmp $

boot_disk: db 0

GDT_Start:
null_descriptor:
    times 8 db 0
code_descriptor:
    dw 0xffff ; first 16 bits of limit
    dw 0 ; first 16
    db 0 ; + 8 = 24 bits of base
    db 0b10011010 ; pres (1), priv (1), type (2), type flags (4)
    db 0b11001111 ; other flags (4), last 4 bits of limit
    db 0 ; last 8 bits of base
data_descriptor:
    dw 0xffff ; first 16 bits of limit
    dw 0 ; first 16
    db 0 ; + 8 = 24 bits of base
    db 0b10010010 ; pres (1), priv (1), type (2), type flags (4)
    db 0b11001111 ; other flags (4), last 4 bits of limit
    db 0 ; last 8 bits of base
GDT_End:
GDT_Descriptor:
    dw GDT_End - GDT_Start - 1 ; size
    dd GDT_Start ; start location

[bits 32]
start_protected_mode:
    mov ax, DATA_SEG
    mov ds, ax
    mov ss, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    mov ebp, 0x90000
    mov esp, ebp
    jmp KERNEL_LOC
    jmp $


; pad with zeros up to 510 bytes (save 2 for signature)
times 510-($-$$) db 0 
db 0x55, 0xaa
