/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.world;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class VoidGenerator
extends ChunkGenerator {
    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        return Collections.emptyList();
    }

    public boolean canSpawn(World world, int x, int z) {
        return true;
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, 100.0, 0.0);
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biome) {
        ChunkGenerator.ChunkData chunkData = super.createChunkData(world);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                biome.setBiome(x, z, Biome.PLAINS);
            }
        }
        return chunkData;
    }

    public byte[] generate(World world, Random random, int x, int z) {
        return new byte[world.getMaxHeight() / 16];
    }

    public byte[][] generateBlockSections(World world, Random random, int x, int z, ChunkGenerator.BiomeGrid biomes) {
        return new byte[world.getMaxHeight() / 16][];
    }
}

