/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game.listener;

import dev.tylerm.depend.xseries.XMaterial;
import dev.tylerm.depend.xseries.messages.ActionBar;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.game.Board;
import dev.tylerm.khs.game.util.Status;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class InteractHandler
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!Main.getInstance().getBoard().contains(event.getPlayer())) {
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getClickedBlock() != null && Config.blockedInteracts.contains(event.getClickedBlock().getType().name())) {
            event.setCancelled(true);
            return;
        }
        ItemStack temp = event.getItem();
        if (temp == null) {
            return;
        }
        if (Main.getInstance().getGame().getStatus() == Status.STANDBY) {
            this.onPlayerInteractLobby(temp, event);
        }
        if (Main.getInstance().getGame().getStatus() == Status.PLAYING) {
            this.onPlayerInteractGame(temp, event);
        }
        if (Main.getInstance().getBoard().isSpectator(event.getPlayer())) {
            this.onSpectatorInteract(temp, event);
        }
    }

    private void onPlayerInteractLobby(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.lobbyLeaveItem)) {
            event.setCancelled(true);
            Main.getInstance().getGame().leave(event.getPlayer());
        }
        if (temp.isSimilar(Config.lobbyStartItem) && event.getPlayer().hasPermission("hideandseek.start")) {
            event.setCancelled(true);
            if (Main.getInstance().getGame().checkCurrentMap()) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
                return;
            }
            if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
                return;
            }
            if (Main.getInstance().getBoard().size() < Config.minPlayers) {
                event.getPlayer().sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
                return;
            }
            Main.getInstance().getGame().start();
        }
    }

    private void onPlayerInteractGame(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.glowPowerupItem)) {
            if (!Config.glowEnabled) {
                return;
            }
            Player player = event.getPlayer();
            if (Main.getInstance().getBoard().isHider(player)) {
                Main.getInstance().getGame().getGlow().onProjectile();
                player.getInventory().remove(Config.glowPowerupItem);
                assert (XMaterial.SNOWBALL.parseMaterial() != null);
                player.getInventory().remove(XMaterial.SNOWBALL.parseMaterial());
                event.setCancelled(true);
            }
        }
    }

    private void onSpectatorInteract(ItemStack temp, PlayerInteractEvent event) {
        if (temp.isSimilar(Config.flightToggleItem)) {
            boolean isFlying = event.getPlayer().getAllowFlight();
            event.getPlayer().setAllowFlight(!isFlying);
            event.getPlayer().setFlying(!isFlying);
            ActionBar.clearActionBar(event.getPlayer());
            if (!isFlying) {
                ActionBar.sendActionBar(event.getPlayer(), Localization.message("FLYING_ENABLED").toString());
            } else {
                ActionBar.sendActionBar(event.getPlayer(), Localization.message("FLYING_DISABLED").toString());
            }
            return;
        }
        if (temp.isSimilar(Config.teleportItem)) {
            InteractHandler.createSpectatorTeleportPage(event.getPlayer(), 0);
        }
    }

    public static void createSpectatorTeleportPage(Player player, int page) {
        if (page < 0) {
            return;
        }
        Board board = Main.getInstance().getBoard();
        ArrayList<Player> players = new ArrayList<Player>();
        players.addAll(board.getHiders());
        players.addAll(board.getSeekers());
        int page_size = 45;
        int amount = players.size();
        int start = page * 45;
        int page_amount = amount - start;
        if (page_amount < 1) {
            return;
        }
        boolean next = false;
        boolean prev = true;
        if (page_amount > 45) {
            page_amount = 45;
            next = true;
        }
        if (page == 0) {
            prev = false;
        }
        int rows = (amount - 1) / 9 + 2;
        Inventory teleportMenu = Main.getInstance().getServer().createInventory(null, 9 * rows, ChatColor.stripColor((String)Config.teleportItem.getItemMeta().getDisplayName()));
        ArrayList<String> hider_lore = new ArrayList<String>();
        hider_lore.add(Localization.message("HIDER_TEAM_NAME").toString());
        ArrayList<String> seeker_lore = new ArrayList<String>();
        seeker_lore.add(Localization.message("SEEKER_TEAM_NAME").toString());
        for (int i = 0; i < page_amount; ++i) {
            Player plr = (Player)players.get(i);
            teleportMenu.addItem(new ItemStack[]{InteractHandler.getSkull(plr, board.isHider(plr) ? hider_lore : seeker_lore)});
        }
        int lastRow = (rows - 1) * 9;
        if (prev) {
            teleportMenu.setItem(lastRow, InteractHandler.getPageItem(page - 1));
        }
        if (next) {
            teleportMenu.setItem(lastRow + 8, InteractHandler.getPageItem(page + 1));
        }
        player.openInventory(teleportMenu);
    }

    private static ItemStack getPageItem(int page) {
        ItemStack prevItem = new ItemStack(XMaterial.ENCHANTED_BOOK.parseMaterial(), page + 1);
        ItemMeta meta = prevItem.getItemMeta();
        meta.setDisplayName("Page " + (page + 1));
        prevItem.setItemMeta(meta);
        return prevItem;
    }

    private static ItemStack getSkull(Player player, List<String> lore) {
        assert (XMaterial.PLAYER_HEAD.parseMaterial() != null);
        ItemStack playerHead = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
        SkullMeta playerHeadMeta = (SkullMeta)playerHead.getItemMeta();
        playerHeadMeta.setOwner(player.getName());
        playerHeadMeta.setDisplayName(player.getName());
        playerHeadMeta.setLore(lore);
        playerHead.setItemMeta((ItemMeta)playerHeadMeta);
        return playerHead;
    }
}

