/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game.listener;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.EnumWrappers;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.game.util.Disguise;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class DisguiseHandler
implements Listener {
    private static final ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
    private final List<Player> debounce = new ArrayList<Player>();

    public DisguiseHandler() {
        protocolManager.addPacketListener((PacketListener)this.createProtocol());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Disguise disguise = Main.getInstance().getDisguiser().getDisguise(player);
        if (disguise == null) {
            return;
        }
        if (event.getFrom().distance(event.getTo()) > 0.1) {
            disguise.setSolidify(false);
        }
        disguise.startSolidifying();
    }

    private PacketAdapter createProtocol() {
        return new PacketAdapter((Plugin)Main.getInstance(), new PacketType[]{PacketType.Play.Client.USE_ENTITY}){

            public void onPacketReceiving(PacketEvent event) {
                PacketContainer packet = event.getPacket();
                EnumWrappers.EntityUseAction action = packet.getEntityUseActions().getValues().stream().findFirst().orElse(null);
                if (action == null) {
                    return;
                }
                if (action.compareTo((Enum)EnumWrappers.EntityUseAction.INTERACT) == 2) {
                    return;
                }
                Player player = event.getPlayer();
                int id = (Integer)packet.getIntegers().read(0);
                Disguise disguise = Main.getInstance().getDisguiser().getByEntityID(id);
                if (disguise == null) {
                    disguise = Main.getInstance().getDisguiser().getByHitBoxID(id);
                }
                if (disguise == null) {
                    return;
                }
                if (disguise.getPlayer().getGameMode() == GameMode.CREATIVE) {
                    return;
                }
                event.setCancelled(true);
                DisguiseHandler.this.handleAttack(disguise, player);
            }
        };
    }

    private void handleAttack(Disguise disguise, Player seeker) {
        if (disguise.getPlayer() == seeker) {
            return;
        }
        if (!Main.getInstance().supports(9)) {
            return;
        }
        double amount = seeker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE).getValue();
        disguise.setSolidify(false);
        if (this.debounce.contains(disguise.getPlayer())) {
            return;
        }
        this.debounce.add(disguise.getPlayer());
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> {
            EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)seeker, (Entity)disguise.getPlayer(), EntityDamageEvent.DamageCause.ENTITY_ATTACK, amount);
            event.setDamage(amount);
            disguise.getPlayer().setLastDamageCause((EntityDamageEvent)event);
            Main.getInstance().getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                disguise.getPlayer().damage(amount);
                disguise.getPlayer().setVelocity(seeker.getLocation().getDirection().setY(0.2).multiply(1));
            }
        }, 0L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> this.debounce.remove(disguise.getPlayer()), 10L);
    }
}

