/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game.events;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;

public class Taunt {
    private UUID tauntPlayer;
    private int delay = Config.tauntDelay;
    private boolean running;

    public void update() {
        if (this.delay == 0) {
            if (this.running) {
                this.launchTaunt();
            } else if (Config.tauntLast || Main.getInstance().getBoard().sizeHider() > 1) {
                this.executeTaunt();
            }
        } else {
            --this.delay;
            this.delay = Math.max(this.delay, 0);
        }
    }

    private void executeTaunt() {
        Optional rand = Main.getInstance().getBoard().getHiders().stream().skip(new Random().nextInt(Main.getInstance().getBoard().size())).findFirst();
        if (!rand.isPresent()) {
            Main.getInstance().getLogger().warning("Failed to select random seeker.");
            return;
        }
        Player taunted = (Player)rand.get();
        taunted.sendMessage(Localization.message("TAUNTED").toString());
        Main.getInstance().getGame().broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT"));
        this.tauntPlayer = taunted.getUniqueId();
        this.running = true;
        this.delay = 30;
    }

    private void launchTaunt() {
        Player taunted = Main.getInstance().getBoard().getPlayer(this.tauntPlayer);
        if (taunted != null) {
            if (!Main.getInstance().getBoard().isHider(taunted)) {
                Main.getInstance().getLogger().info("Taunted played died and is now seeker. Skipping taunt.");
                this.tauntPlayer = null;
                this.running = false;
                this.delay = Config.tauntDelay;
                return;
            }
            World world = taunted.getLocation().getWorld();
            if (world == null) {
                Main.getInstance().getLogger().severe("Game world is null while trying to launch taunt.");
                this.tauntPlayer = null;
                this.running = false;
                this.delay = Config.tauntDelay;
                return;
            }
            Firework fw = (Firework)world.spawnEntity(taunted.getLocation(), EntityType.FIREWORK);
            FireworkMeta fwm = fw.getFireworkMeta();
            fwm.setPower(4);
            fwm.addEffect(FireworkEffect.builder().withColor(Color.BLUE).withColor(Color.RED).withColor(Color.YELLOW).with(FireworkEffect.Type.STAR).with(FireworkEffect.Type.BALL).with(FireworkEffect.Type.BALL_LARGE).flicker(true).withTrail().build());
            fw.setFireworkMeta(fwm);
            Main.getInstance().getGame().broadcastMessage(Config.tauntPrefix + Localization.message("TAUNT_ACTIVATE"));
        }
        this.tauntPlayer = null;
        this.running = false;
        this.delay = Config.tauntDelay;
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

