/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game.events;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.util.packet.EntityMetadataPacket;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class Glow {
    private static final ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
    private int glowTime = 0;
    private boolean running;

    public void onProjectile() {
        this.glowTime = Config.glowStackable ? (this.glowTime += Config.glowLength) : Config.glowLength;
        this.running = true;
    }

    private void sendPackets() {
        for (Player hider : Main.getInstance().getBoard().getHiders()) {
            for (Player seeker : Main.getInstance().getBoard().getSeekers()) {
                this.setGlow(hider, seeker, true);
            }
        }
    }

    public void update() {
        if (Config.alwaysGlow) {
            this.sendPackets();
            return;
        }
        if (this.running) {
            this.sendPackets();
            --this.glowTime;
            this.glowTime = Math.max(this.glowTime, 0);
            if (this.glowTime == 0) {
                this.stopGlow();
            }
        }
    }

    private void stopGlow() {
        this.running = false;
        for (Player hider : Main.getInstance().getBoard().getHiders()) {
            for (Player seeker : Main.getInstance().getBoard().getSeekers()) {
                this.setGlow(hider, seeker, false);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setGlow(Player player, Player target, boolean glowing) {
        EntityMetadataPacket packet = new EntityMetadataPacket();
        packet.setEntity((Entity)target);
        packet.setGlow(glowing);
        packet.writeMetadata();
        packet.send(player);
    }
}

