/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game;

import dev.tylerm.depend.xseries.messages.Titles;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Items;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Map;
import dev.tylerm.khs.game.Board;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerLoader {
    public static void loadHider(Player player, Map map) {
        map.getGameSpawn().teleport(player);
        PlayerLoader.loadPlayer(player);
        player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 1000000, 5, false, false));
        Titles.sendTitle(player, 10, 70, 20, ChatColor.WHITE + "" + Localization.message("HIDER_TEAM_NAME"), ChatColor.WHITE + Localization.message("HIDERS_SUBTITLE").toString());
        if (map.isBlockHuntEnabled()) {
            PlayerLoader.openBlockHuntPicker(player, map);
        }
    }

    public static void loadSeeker(Player player, Map map) {
        map.getGameSeekerLobby().teleport(player);
        PlayerLoader.loadPlayer(player);
        Titles.sendTitle(player, 10, 70, 20, ChatColor.WHITE + "" + Localization.message("SEEKER_TEAM_NAME"), ChatColor.WHITE + Localization.message("SEEKERS_SUBTITLE").toString());
    }

    public static void loadSpectator(Player player, Map map) {
        map.getGameSpawn().teleport(player);
        PlayerLoader.loadPlayer(player);
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setFallDistance(0.0f);
        player.getInventory().setItem(Config.flightToggleItemPosition, Config.flightToggleItem);
        player.getInventory().setItem(Config.teleportItemPosition, Config.teleportItem);
        Main.getInstance().getBoard().getPlayers().forEach(otherPlayer -> otherPlayer.hidePlayer(player));
        Titles.sendTitle(player, 10, 70, 20, ChatColor.GRAY + "" + ChatColor.BOLD + "SPECTATING", ChatColor.WHITE + Localization.message("SPECTATOR_SUBTITLE").toString());
    }

    public static void loadDeadHiderSpectator(Player player, Map map) {
        map.getGameSpawn().teleport(player);
        PlayerLoader.loadPlayer(player);
        player.setAllowFlight(true);
        player.setFlying(true);
        player.setFallDistance(0.0f);
        player.getInventory().setItem(Config.flightToggleItemPosition, Config.flightToggleItem);
        player.getInventory().setItem(Config.teleportItemPosition, Config.teleportItem);
        Main.getInstance().getBoard().getPlayers().forEach(otherPlayer -> otherPlayer.hidePlayer(player));
    }

    public static void resetPlayer(Player player, Board board) {
        if (board.isSpectator(player)) {
            return;
        }
        PlayerLoader.loadPlayer(player);
        if (board.isSeeker(player)) {
            if (Config.pvpEnabled) {
                for (int i = 0; i < 9; ++i) {
                    if (Items.SEEKER_ITEMS.get(i) == null) continue;
                    player.getInventory().setItem(i, Items.SEEKER_ITEMS.get(i));
                }
                if (Items.SEEKER_HELM != null) {
                    player.getInventory().setHelmet(Items.SEEKER_HELM);
                }
                if (Items.SEEKER_CHEST != null) {
                    player.getInventory().setChestplate(Items.SEEKER_CHEST);
                }
                if (Items.SEEKER_LEGS != null) {
                    player.getInventory().setLeggings(Items.SEEKER_LEGS);
                }
                if (Items.SEEKER_BOOTS != null) {
                    player.getInventory().setBoots(Items.SEEKER_BOOTS);
                }
            }
            for (PotionEffect effect : Items.SEEKER_EFFECTS) {
                player.addPotionEffect(effect);
            }
        } else if (board.isHider(player)) {
            if (Config.pvpEnabled) {
                for (int i = 0; i < 9; ++i) {
                    if (Items.HIDER_ITEMS.get(i) == null) continue;
                    player.getInventory().setItem(i, Items.HIDER_ITEMS.get(i));
                }
                if (Items.HIDER_HELM != null) {
                    player.getInventory().setHelmet(Items.HIDER_HELM);
                }
                if (Items.HIDER_CHEST != null) {
                    player.getInventory().setChestplate(Items.HIDER_CHEST);
                }
                if (Items.HIDER_LEGS != null) {
                    player.getInventory().setLeggings(Items.HIDER_LEGS);
                }
                if (Items.HIDER_BOOTS != null) {
                    player.getInventory().setBoots(Items.HIDER_BOOTS);
                }
            }
            for (PotionEffect effect : Items.HIDER_EFFECTS) {
                player.addPotionEffect(effect);
            }
            if (Config.glowEnabled) {
                player.getInventory().addItem(new ItemStack[]{Config.glowPowerupItem});
            }
        }
    }

    public static void unloadPlayer(Player player) {
        player.setGameMode(GameMode.ADVENTURE);
        player.getInventory().clear();
        Main.getInstance().getDisguiser().reveal(player);
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        if (Main.getInstance().supports(9)) {
            AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attribute != null) {
                player.setHealth(attribute.getValue());
            }
            for (Player temp2 : Main.getInstance().getBoard().getPlayers()) {
                Main.getInstance().getGame().getGlow().setGlow(player, temp2, false);
            }
        } else {
            player.setHealth(player.getMaxHealth());
        }
        Main.getInstance().getBoard().getPlayers().forEach(temp -> {
            player.showPlayer(temp);
            temp.showPlayer(player);
        });
        player.setAllowFlight(false);
        player.setFlying(false);
        player.setFallDistance(0.0f);
    }

    public static void joinPlayer(Player player, Map map) {
        map.getLobby().teleport(player);
        PlayerLoader.loadPlayer(player);
        if (Config.lobbyStartItem != null && (!Config.lobbyItemStartAdmin || player.hasPermission("hideandseek.start"))) {
            player.getInventory().setItem(Config.lobbyItemStartPosition, Config.lobbyStartItem);
        }
        if (Config.lobbyLeaveItem != null) {
            player.getInventory().setItem(Config.lobbyItemLeavePosition, Config.lobbyLeaveItem);
        }
    }

    private static void loadPlayer(Player player) {
        player.setFlying(false);
        player.setAllowFlight(false);
        player.setGameMode(GameMode.ADVENTURE);
        player.getInventory().clear();
        for (PotionEffect effect : player.getActivePotionEffects()) {
            if (effect.getType().getName().equals("INVISIBILITY") && Main.getInstance().getDisguiser().disguised(player)) continue;
            player.removePotionEffect(effect.getType());
        }
        player.setFoodLevel(20);
        if (Main.getInstance().supports(9)) {
            AttributeInstance attribute = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            if (attribute != null) {
                player.setHealth(attribute.getValue());
            }
        } else {
            player.setHealth(player.getMaxHealth());
        }
    }

    public static void openBlockHuntPicker(Player player, Map map) {
        int slots = (map.getBlockHunt().size() - 1) / 9 * 9 + 9;
        Inventory inventory = Main.getInstance().getServer().createInventory(null, slots, "Select a Block: " + map.getName());
        for (int i = 0; i < map.getBlockHunt().size(); ++i) {
            inventory.setItem(i, new ItemStack(map.getBlockHunt().get(i)));
        }
        player.openInventory(inventory);
    }
}

