/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.game;

import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Map;
import dev.tylerm.khs.game.util.Disguise;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class Disguiser {
    private final HashMap<Player, Disguise> disguises = new HashMap();

    public Disguise getDisguise(Player player) {
        return this.disguises.get(player);
    }

    public boolean disguised(Player player) {
        return this.disguises.containsKey(player);
    }

    @Nullable
    public Disguise getByEntityID(int ID) {
        return this.disguises.values().stream().filter(disguise -> disguise.getEntityID() == ID).findFirst().orElse(null);
    }

    @Nullable
    public Disguise getByHitBoxID(int ID) {
        return this.disguises.values().stream().filter(disguise -> disguise.getHitBoxID() == ID).findFirst().orElse(null);
    }

    public void check() {
        for (Map.Entry<Player, Disguise> set : this.disguises.entrySet()) {
            Disguise disguise = set.getValue();
            Player player = set.getKey();
            if (!player.isOnline()) {
                disguise.remove();
                this.disguises.remove(player);
                continue;
            }
            disguise.update();
        }
    }

    public void disguise(Player player, Material material, Map map) {
        if (!map.isBlockHuntEnabled()) {
            player.sendMessage(Config.errorPrefix + Localization.message("BLOCKHUNT_DISABLED"));
            return;
        }
        if (this.disguises.containsKey(player)) {
            this.disguises.get(player).remove();
        }
        Disguise disguise = new Disguise(player, material);
        this.disguises.put(player, disguise);
    }

    public void reveal(Player player) {
        if (this.disguises.containsKey(player)) {
            this.disguises.get(player).remove();
        }
        this.disguises.remove(player);
    }

    public void cleanUp() {
        this.disguises.values().forEach(Disguise::remove);
    }
}

