/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.database.connections;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.database.connections.DatabaseConnection;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.sqlite.SQLiteConfig;

public class SQLiteConnection
implements DatabaseConnection {
    private final File databaseFile;
    private final SQLiteConfig config;

    public SQLiteConnection() {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            Main.getInstance().getLogger().severe(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        this.databaseFile = new File(Main.getInstance().getDataFolder(), "database.db");
        this.config = new SQLiteConfig();
        this.config.setSynchronous(SQLiteConfig.SynchronousMode.NORMAL);
        this.config.setTempStore(SQLiteConfig.TempStore.MEMORY);
    }

    @Override
    public Connection connect() {
        Connection conn = null;
        try {
            String url = "jdbc:sqlite:" + this.databaseFile.getPath();
            conn = DriverManager.getConnection(url, this.config.toProperties());
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe(e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }
}

