/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.database;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.database.Database;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class InventoryTable {
    private final Database database;

    protected InventoryTable(Database database) {
        String sql = "CREATE TABLE IF NOT EXISTS hs_inventory (\n\tuuid BINARY(16) NOT NULL,\n\tinventory TEXT NOT NULL,\n\tPRIMARY KEY (uuid)\n);";
        try (Connection connection = database.connect();
             Statement statement = connection.createStatement();){
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
        this.database = database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ItemStack[] getInventory(@NotNull UUID uuid) {
        String sql = "SELECT * FROM hs_inventory WHERE uuid = ?;";
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, this.database.encodeUUID(uuid));
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                String data = rs.getString("inventory");
                if (data == null) {
                    ItemStack[] itemStackArray = null;
                    return itemStackArray;
                }
                ItemStack[] itemStackArray = this.itemStackArrayFromBase64(data);
                return itemStackArray;
            }
            rs.close();
            return null;
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            Main.getInstance().getLogger().severe("IO Error: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public void saveInventory(@NotNull UUID uuid, @NotNull ItemStack[] itemArray) {
        String sql = "REPLACE INTO hs_inventory (uuid, inventory) VALUES (?,?)";
        String data = this.itemStackArrayToBase64(itemArray);
        try (Connection connection = this.database.connect();
             PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setBytes(1, this.database.encodeUUID(uuid));
            statement.setString(2, data);
            statement.execute();
        }
        catch (SQLException e) {
            Main.getInstance().getLogger().severe("SQL Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String itemStackArrayToBase64(ItemStack[] itemArray) throws IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
            dataOutput.writeObject((Object)itemArray);
            dataOutput.close();
            return Base64Coder.encodeLines((byte[])outputStream.toByteArray());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error whilst saving items, Please contact the developer", e);
        }
    }

    private ItemStack[] itemStackArrayFromBase64(String data) throws IOException {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)data));
            BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
            ItemStack[] itemArray = (ItemStack[])dataInput.readObject();
            dataInput.close();
            return itemArray;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Error whilst loading items, Please contact the developer", e);
        }
    }
}

