/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.configuration;

import dev.tylerm.depend.xseries.XItemStack;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.configuration.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Items {
    public static List<ItemStack> HIDER_ITEMS;
    public static List<ItemStack> SEEKER_ITEMS;
    public static ItemStack HIDER_HELM;
    public static ItemStack SEEKER_HELM;
    public static ItemStack HIDER_CHEST;
    public static ItemStack SEEKER_CHEST;
    public static ItemStack HIDER_LEGS;
    public static ItemStack SEEKER_LEGS;
    public static ItemStack HIDER_BOOTS;
    public static ItemStack SEEKER_BOOTS;
    public static List<PotionEffect> HIDER_EFFECTS;
    public static List<PotionEffect> SEEKER_EFFECTS;

    public static void loadItems() {
        ConfigurationSection section;
        ConfigurationSection section2;
        ItemStack item;
        ConfigurationSection HiderBoots;
        ItemStack item2;
        ConfigurationSection HiderLeggings;
        ConfigurationSection HiderChestplate;
        ItemStack item3;
        ItemStack item4;
        ItemStack item5;
        ConfigurationSection SeekerBoots;
        ItemStack item6;
        ConfigurationSection SeekerLeggings;
        ConfigurationSection SeekerChestplate;
        ItemStack item7;
        ItemStack item8;
        ConfigManager manager = ConfigManager.create("items.yml");
        SEEKER_ITEMS = new ArrayList<ItemStack>();
        SEEKER_HELM = null;
        SEEKER_CHEST = null;
        SEEKER_LEGS = null;
        SEEKER_BOOTS = null;
        ConfigurationSection SeekerItems = manager.getConfigurationSection("items.seeker");
        for (int i = 0; i < 9; ++i) {
            ConfigurationSection section3 = SeekerItems.getConfigurationSection(String.valueOf(i));
            if (section3 == null) {
                SEEKER_ITEMS.add(null);
                continue;
            }
            item8 = Items.createItem(section3);
            SEEKER_ITEMS.add(item8);
        }
        ConfigurationSection SeekerHelmet = SeekerItems.getConfigurationSection("helmet");
        if (SeekerHelmet != null && (item7 = Items.createItem(SeekerHelmet)) != null) {
            SEEKER_HELM = item7;
        }
        if ((SeekerChestplate = SeekerItems.getConfigurationSection("chestplate")) != null && (item8 = Items.createItem(SeekerChestplate)) != null) {
            SEEKER_CHEST = item8;
        }
        if ((SeekerLeggings = SeekerItems.getConfigurationSection("leggings")) != null && (item6 = Items.createItem(SeekerLeggings)) != null) {
            SEEKER_LEGS = item6;
        }
        if ((SeekerBoots = SeekerItems.getConfigurationSection("boots")) != null && (item5 = Items.createItem(SeekerBoots)) != null) {
            SEEKER_BOOTS = item5;
        }
        HIDER_ITEMS = new ArrayList<ItemStack>();
        HIDER_HELM = null;
        HIDER_CHEST = null;
        HIDER_LEGS = null;
        HIDER_BOOTS = null;
        ConfigurationSection HiderItems = manager.getConfigurationSection("items.hider");
        for (int i = 0; i < 9; ++i) {
            ConfigurationSection section4 = HiderItems.getConfigurationSection(String.valueOf(i));
            if (section4 == null) {
                HIDER_ITEMS.add(null);
                continue;
            }
            item4 = Items.createItem(section4);
            HIDER_ITEMS.add(item4);
        }
        ConfigurationSection HiderHelmet = HiderItems.getConfigurationSection("helmet");
        if (HiderHelmet != null && (item3 = Items.createItem(HiderHelmet)) != null) {
            HIDER_HELM = item3;
        }
        if ((HiderChestplate = HiderItems.getConfigurationSection("chestplate")) != null && (item4 = Items.createItem(HiderChestplate)) != null) {
            HIDER_CHEST = item4;
        }
        if ((HiderLeggings = HiderItems.getConfigurationSection("leggings")) != null && (item2 = Items.createItem(HiderLeggings)) != null) {
            HIDER_LEGS = item2;
        }
        if ((HiderBoots = HiderItems.getConfigurationSection("boots")) != null && (item = Items.createItem(HiderBoots)) != null) {
            HIDER_BOOTS = item;
        }
        SEEKER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection SeekerEffects = manager.getConfigurationSection("effects.seeker");
        int i = 1;
        while ((section2 = SeekerEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section2);
            if (effect != null) {
                SEEKER_EFFECTS.add(effect);
            }
            ++i;
        }
        HIDER_EFFECTS = new ArrayList<PotionEffect>();
        ConfigurationSection HiderEffects = manager.getConfigurationSection("effects.hider");
        i = 1;
        while ((section = HiderEffects.getConfigurationSection(String.valueOf(i))) != null) {
            PotionEffect effect = Items.getPotionEffect(section);
            if (effect != null) {
                HIDER_EFFECTS.add(effect);
            }
            ++i;
        }
    }

    private static ItemStack createItem(ConfigurationSection item) {
        ConfigurationSection config = new YamlConfiguration().createSection("temp");
        String material = item.getString("material").toUpperCase();
        boolean splash = false;
        if (!Main.getInstance().supports(9)) {
            if (material.contains("POTION")) {
                config.set("level", (Object)1);
            }
            if (material.equalsIgnoreCase("SPLASH_POTION") || material.equalsIgnoreCase("LINGERING_POTION")) {
                material = "POTION";
                splash = true;
            }
        }
        config.set("name", (Object)item.getString("name"));
        config.set("material", (Object)material);
        config.set("enchants", (Object)item.getConfigurationSection("enchantments"));
        config.set("unbreakable", (Object)item.getBoolean("unbreakable"));
        if (Main.getInstance().supports(14) && item.contains("model-data")) {
            config.set("model-data", (Object)item.getInt("model-data"));
        }
        if (item.isSet("lore")) {
            config.set("lore", (Object)item.getStringList("lore"));
        }
        if (material.equalsIgnoreCase("POTION") || material.equalsIgnoreCase("SPLASH_POTION") || material.equalsIgnoreCase("LINGERING_POTION")) {
            config.set("base-effect", (Object)String.format("%s,%s,%s", item.getString("type"), false, splash));
        }
        ItemStack stack = XItemStack.deserialize(config);
        int amt = item.getInt("amount");
        if (amt < 1) {
            amt = 1;
        }
        stack.setAmount(amt);
        if (stack.getData().getItemType() == Material.AIR) {
            return null;
        }
        return stack;
    }

    private static PotionEffect getPotionEffect(ConfigurationSection item) {
        String type = item.getString("type");
        if (type == null) {
            return null;
        }
        if (PotionEffectType.getByName((String)type.toUpperCase()) == null) {
            return null;
        }
        return new PotionEffect(PotionEffectType.getByName((String)type.toUpperCase()), item.getInt("duration"), item.getInt("amplifier"), item.getBoolean("ambient"), item.getBoolean("particles"));
    }

    public static boolean matchItem(ItemStack stack) {
        for (ItemStack check : HIDER_ITEMS) {
            if (!Items.equals(stack, check)) continue;
            return true;
        }
        for (ItemStack check : SEEKER_ITEMS) {
            if (!Items.equals(stack, check)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        return a.getType() == b.getType() && a.hasItemMeta() == b.hasItemMeta() && (!a.hasItemMeta() || Bukkit.getItemFactory().equals(a.getItemMeta(), b.getItemMeta()));
    }
}

