/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command.world;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class List
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        java.util.List<String> worlds = Main.getInstance().getWorlds();
        if (worlds.isEmpty()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NO_WORLDS"));
        } else {
            StringBuilder response = new StringBuilder(Config.messagePrefix + Localization.message("LIST_WORLDS"));
            for (String world : worlds) {
                String status = ChatColor.GRAY + "NOT LOADED";
                World bukkit_world = Bukkit.getWorld((String)world);
                if (bukkit_world != null) {
                    status = bukkit_world.getEnvironment() == World.Environment.NETHER ? ChatColor.RED + "NETHER" : (bukkit_world.getEnvironment() == World.Environment.THE_END ? ChatColor.YELLOW + "THE END" : ChatColor.GREEN + bukkit_world.getWorldType().toString());
                }
                response.append("\n    ").append(world).append(": ").append(status).append(ChatColor.WHITE);
            }
            sender.sendMessage(response.toString());
        }
    }

    @Override
    public String getLabel() {
        return "list";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "List all worlds in the server";
    }

    @Override
    public java.util.List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return null;
    }
}

