/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command.map;

import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Map;
import dev.tylerm.khs.configuration.Maps;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class List
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        Collection<Map> maps = Maps.getAllMaps();
        if (maps.size() < 1) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NO_MAPS"));
            return;
        }
        StringBuilder response = new StringBuilder(Config.messagePrefix + Localization.message("LIST_MAPS"));
        for (Map map : maps) {
            response.append("\n    ").append(map.getName()).append(": ").append(map.isNotSetup() ? ChatColor.RED + "NOT SETUP" : ChatColor.GREEN + "SETUP").append(ChatColor.WHITE);
        }
        sender.sendMessage(response.toString());
    }

    @Override
    public String getLabel() {
        return "list";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "List all maps in the plugin";
    }

    @Override
    public java.util.List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return null;
    }
}

