/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command.map;

import dev.tylerm.depend.xseries.XMaterial;
import dev.tylerm.khs.Main;
import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Map;
import dev.tylerm.khs.configuration.Maps;
import dev.tylerm.khs.game.PlayerLoader;
import dev.tylerm.khs.game.util.Status;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Debug
implements ICommand {
    private static final java.util.Map<Player, java.util.Map<Integer, Consumer<Player>>> debugMenuFunctions = new HashMap<Player, java.util.Map<Integer, Consumer<Player>>>();

    @Override
    public void execute(Player sender, String[] args) {
        Map map = Maps.getMap(args[0]);
        if (map == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
            return;
        }
        Inventory debugMenu = this.createMenu(map, sender);
        sender.openInventory(debugMenu);
    }

    private Inventory createMenu(Map map, Player sender) {
        HashMap<Integer, Consumer<Player>> functions = new HashMap<Integer, Consumer<Player>>();
        Inventory debugMenu = Main.getInstance().getServer().createInventory(null, 9, "Debug Menu");
        debugMenu.setItem(0, this.createOption(functions, 0, XMaterial.LEATHER_CHESTPLATE.parseMaterial(), "&6Become a &lHider", 1, player -> {
            if (Config.mapSaveEnabled && map.getGameSpawn().getWorld() == null) {
                map.getWorldLoader().loadMap();
            }
            Main.getInstance().getBoard().addHider((Player)player);
            PlayerLoader.loadHider(player, map);
            if (Main.getInstance().getGame().getStatus() != Status.STARTING) {
                PlayerLoader.resetPlayer(player, Main.getInstance().getBoard());
            }
        }));
        debugMenu.setItem(1, this.createOption(functions, 1, XMaterial.GOLDEN_CHESTPLATE.parseMaterial(), "&cBecome a &lSeeker", 1, player -> {
            if (Config.mapSaveEnabled && map.getGameSpawn().getWorld() == null) {
                map.getWorldLoader().loadMap();
            }
            Main.getInstance().getBoard().addSeeker((Player)player);
            PlayerLoader.loadSeeker(player, map);
            if (Main.getInstance().getGame().getStatus() != Status.STARTING) {
                PlayerLoader.resetPlayer(player, Main.getInstance().getBoard());
            }
        }));
        debugMenu.setItem(2, this.createOption(functions, 2, XMaterial.IRON_CHESTPLATE.parseMaterial(), "&8Become a &lSpectator", 1, player -> {
            if (Config.mapSaveEnabled && map.getGameSpawn().getWorld() == null) {
                map.getWorldLoader().loadMap();
            }
            Main.getInstance().getBoard().addSpectator((Player)player);
            PlayerLoader.loadSpectator(player, map);
        }));
        debugMenu.setItem(3, this.createOption(functions, 3, XMaterial.BARRIER.parseMaterial(), "&cUnload from Game", 1, player -> {
            Main.getInstance().getBoard().remove((Player)player);
            PlayerLoader.unloadPlayer(player);
            Config.exitPosition.teleport((Player)player);
        }));
        debugMenu.setItem(4, this.createOption(functions, 4, XMaterial.BARRIER.parseMaterial(), "&cDie In Game", 2, player -> {
            if ((Main.getInstance().getBoard().isSeeker((Player)player) || Main.getInstance().getBoard().isHider((Player)player)) && Main.getInstance().getGame().getStatus() == Status.PLAYING) {
                player.setHealth(0.1);
            }
        }));
        if (map.isBlockHuntEnabled()) {
            debugMenu.setItem(7, this.createOption(functions, 7, XMaterial.GLASS.parseMaterial(), "&dEnable Disguise", 1, player -> PlayerLoader.openBlockHuntPicker(player, map)));
            debugMenu.setItem(8, this.createOption(functions, 8, XMaterial.PLAYER_HEAD.parseMaterial(), "&dDisable Disguise", 1, player -> Main.getInstance().getDisguiser().reveal((Player)player)));
        }
        debugMenuFunctions.put(sender, functions);
        return debugMenu;
    }

    private ItemStack createOption(java.util.Map<Integer, Consumer<Player>> functions, int slow, Material material, String name, int amount, Consumer<Player> callback) {
        ItemStack temp = new ItemStack(material, amount);
        ItemMeta meta = temp.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        temp.setItemMeta(meta);
        functions.put(slow, callback);
        return temp;
    }

    public static void handleOption(Player player, int slotId) {
        Main.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> {
            Consumer<Player> callback = debugMenuFunctions.get(player).get(slotId);
            if (callback != null) {
                callback.accept(player);
            }
        }, 0L);
    }

    @Override
    public String getLabel() {
        return "debug";
    }

    @Override
    public String getUsage() {
        return "<map>";
    }

    @Override
    public String getDescription() {
        return "Run debug commands";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

