/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.database.util.PlayerInfo;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Top
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        int page;
        if (args.length == 0) {
            page = 1;
        } else {
            try {
                page = Integer.parseInt(args[0]);
            }
            catch (Exception e) {
                sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(args[0]));
                return;
            }
        }
        if (page < 1) {
            sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_INVALID_INPUT").addAmount(page));
            return;
        }
        StringBuilder message = new StringBuilder(String.format("%s------- %sLEADERBOARD %s(Page %s) %s-------\n", ChatColor.WHITE, ChatColor.BOLD, ChatColor.GRAY, page, ChatColor.WHITE));
        List<PlayerInfo> infos = Main.getInstance().getDatabase().getGameData().getInfoPage(page);
        int i = 1 + (page - 1) * 10;
        if (infos == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NO_GAME_INFO"));
            return;
        }
        for (PlayerInfo info : infos) {
            ChatColor color;
            String name = Main.getInstance().getDatabase().getNameData().getName(info.getUniqueId());
            switch (i) {
                case 1: {
                    color = ChatColor.YELLOW;
                    break;
                }
                case 2: {
                    color = ChatColor.GRAY;
                    break;
                }
                case 3: {
                    color = ChatColor.GOLD;
                    break;
                }
                default: {
                    color = ChatColor.WHITE;
                }
            }
            message.append(String.format("%s%s. %s%s %s%s\n", color, i, ChatColor.RED, info.getSeekerWins() + info.getHiderWins(), ChatColor.WHITE, name));
            ++i;
        }
        sender.sendMessage(message.toString());
    }

    @Override
    public String getLabel() {
        return "top";
    }

    @Override
    public String getUsage() {
        return "<*page>";
    }

    @Override
    public String getDescription() {
        return "Gets the top players in the server.";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return Collections.singletonList(parameter);
    }
}

