/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.game.util.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Start
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().checkCurrentMap()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        if (!Main.getInstance().getBoard().contains(sender)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_NOT_INGAME"));
            return;
        }
        if (Main.getInstance().getBoard().size() < Config.minPlayers) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
            return;
        }
        if (args.length < 1) {
            Main.getInstance().getGame().start();
            return;
        }
        ArrayList<Player> initialSeekers = new ArrayList<Player>();
        for (int i = 0; i < args.length; ++i) {
            Player seeker = Bukkit.getPlayer((String)args[i]);
            if (seeker == null || !Main.getInstance().getBoard().contains(seeker) || initialSeekers.contains(seeker)) {
                sender.sendMessage(Config.errorPrefix + Localization.message("START_INVALID_NAME").addPlayer(args[i]));
                return;
            }
            initialSeekers.add(seeker);
        }
        int minHiders = Config.minPlayers - Config.startingSeekerCount;
        if (Main.getInstance().getBoard().size() - initialSeekers.size() < minHiders) {
            sender.sendMessage(Config.errorPrefix + Localization.message("START_MIN_PLAYERS").addAmount(Config.minPlayers));
            return;
        }
        Main.getInstance().getGame().start(initialSeekers);
    }

    @Override
    public String getLabel() {
        return "start";
    }

    @Override
    public String getUsage() {
        return "<*seekers...>";
    }

    @Override
    public String getDescription() {
        return "Starts the game either with a random set of seekers or a chosen list";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return Main.getInstance().getBoard().getPlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList());
    }
}

