/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs.command;

import dev.tylerm.khs.Main;
import dev.tylerm.khs.command.util.ICommand;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Items;
import dev.tylerm.khs.configuration.Leaderboard;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Maps;
import dev.tylerm.khs.game.util.Status;
import java.util.List;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Reload
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        try {
            Config.loadConfig();
            Maps.loadMaps();
            Localization.loadLocalization();
            Items.loadItems();
            Leaderboard.loadLeaderboard();
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("CONFIG_ERROR"));
            return;
        }
        sender.sendMessage(Config.messagePrefix + Localization.message("CONFIG_RELOAD"));
    }

    @Override
    public String getLabel() {
        return "reload";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Reloads the config";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return null;
    }
}

