/*
 * Decompiled with CFR 0.152.
 */
package dev.tylerm.khs;

import dev.tylerm.khs.command.Confirm;
import dev.tylerm.khs.command.Help;
import dev.tylerm.khs.command.Join;
import dev.tylerm.khs.command.Leave;
import dev.tylerm.khs.command.Reload;
import dev.tylerm.khs.command.Send;
import dev.tylerm.khs.command.SetExitLocation;
import dev.tylerm.khs.command.Start;
import dev.tylerm.khs.command.Stop;
import dev.tylerm.khs.command.Top;
import dev.tylerm.khs.command.Wins;
import dev.tylerm.khs.command.map.Debug;
import dev.tylerm.khs.command.map.GoTo;
import dev.tylerm.khs.command.map.Save;
import dev.tylerm.khs.command.map.Status;
import dev.tylerm.khs.command.map.blockhunt.Enabled;
import dev.tylerm.khs.command.map.blockhunt.blocks.Add;
import dev.tylerm.khs.command.map.blockhunt.blocks.Remove;
import dev.tylerm.khs.command.map.set.Border;
import dev.tylerm.khs.command.map.set.Bounds;
import dev.tylerm.khs.command.map.set.Lobby;
import dev.tylerm.khs.command.map.set.SeekerLobby;
import dev.tylerm.khs.command.map.set.Spawn;
import dev.tylerm.khs.command.util.CommandGroup;
import dev.tylerm.khs.command.world.Create;
import dev.tylerm.khs.command.world.Delete;
import dev.tylerm.khs.command.world.List;
import dev.tylerm.khs.command.world.Tp;
import dev.tylerm.khs.configuration.Config;
import dev.tylerm.khs.configuration.Items;
import dev.tylerm.khs.configuration.Leaderboard;
import dev.tylerm.khs.configuration.Localization;
import dev.tylerm.khs.configuration.Maps;
import dev.tylerm.khs.database.Database;
import dev.tylerm.khs.game.Board;
import dev.tylerm.khs.game.Disguiser;
import dev.tylerm.khs.game.EntityHider;
import dev.tylerm.khs.game.Game;
import dev.tylerm.khs.game.PlayerLoader;
import dev.tylerm.khs.game.listener.BlockedCommandHandler;
import dev.tylerm.khs.game.listener.ChatHandler;
import dev.tylerm.khs.game.listener.DamageHandler;
import dev.tylerm.khs.game.listener.DisguiseHandler;
import dev.tylerm.khs.game.listener.InteractHandler;
import dev.tylerm.khs.game.listener.InventoryHandler;
import dev.tylerm.khs.game.listener.JoinLeaveHandler;
import dev.tylerm.khs.game.listener.MovementHandler;
import dev.tylerm.khs.game.listener.PlayerHandler;
import dev.tylerm.khs.game.listener.RespawnHandler;
import dev.tylerm.khs.game.listener.WorldInteractHandler;
import dev.tylerm.khs.util.PAPIExpansion;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Main
extends JavaPlugin
implements Listener {
    private static Main instance;
    private static int version;
    private static int sub_version;
    private Database database;
    private Board board;
    private Disguiser disguiser;
    private EntityHider entityHider;
    private Game game;
    private CommandGroup commandGroup;
    private boolean loaded;

    public void onEnable() {
        long start = System.currentTimeMillis();
        this.getLogger().info("Loading Kenshin's Hide and Seek");
        instance = this;
        this.getLogger().info("Getting minecraft version...");
        this.updateVersion();
        try {
            this.getLogger().info("Loading config.yml...");
            Config.loadConfig();
            this.getLogger().info("Loading maps.yml...");
            Maps.loadMaps();
            this.getLogger().info("Loading localization.yml...");
            Localization.loadLocalization();
            this.getLogger().info("Loading items.yml...");
            Items.loadItems();
            this.getLogger().info("Loading leaderboard.yml...");
            Leaderboard.loadLeaderboard();
        }
        catch (Exception e) {
            this.getLogger().severe(e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Creating internal scoreboard...");
        this.board = new Board();
        this.getLogger().info("Connecting to database...");
        this.database = new Database();
        this.getLogger().info("Loading disguises...");
        this.disguiser = new Disguiser();
        this.getLogger().info("Loading entity hider...");
        this.entityHider = new EntityHider((Plugin)this, EntityHider.Policy.BLACKLIST);
        this.getLogger().info("Registering listeners...");
        this.registerListeners();
        this.getLogger().info("Registering commands...");
        this.commandGroup = new CommandGroup("hs", new Help(), new Reload(), new Join(), new Leave(), new Send(), new Start(), new Stop(), new CommandGroup("map", new CommandGroup("blockhunt", new CommandGroup("blocks", new Add(), new Remove(), new dev.tylerm.khs.command.map.blockhunt.blocks.List()), new Enabled()), new CommandGroup("set", new Lobby(), new Spawn(), new SeekerLobby(), new Border(), new Bounds()), new CommandGroup("unset", new dev.tylerm.khs.command.map.unset.Border()), new dev.tylerm.khs.command.map.Add(), new dev.tylerm.khs.command.map.Remove(), new dev.tylerm.khs.command.map.List(), new Status(), new Save(), new Debug(), new GoTo()), new CommandGroup("world", new Create(), new Delete(), new List(), new Tp()), new SetExitLocation(), new Top(), new Wins(), new Confirm());
        this.getLogger().info("Loading game...");
        this.game = new Game(null, this.board);
        this.getLogger().info("Scheduling tick tasks...");
        this.getServer().getScheduler().runTaskTimer((Plugin)this, this::onTick, 0L, 1L).getTaskId();
        this.getLogger().info("Registering outgoing bungeecord plugin channel...");
        Bukkit.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getLogger().info("Checking for PlaceholderAPI...");
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.getLogger().info("PlaceholderAPI found...");
            this.getLogger().info("Registering PlaceholderAPI expansion...");
            new PAPIExpansion().register();
        }
        long end = System.currentTimeMillis();
        this.getLogger().info("Finished loading plugin (" + (end - start) + "ms)");
        this.loaded = true;
    }

    public void onDisable() {
        version = 0;
        if (this.board != null) {
            this.board.getPlayers().forEach(player -> {
                this.board.removeBoard((Player)player);
                PlayerLoader.unloadPlayer(player);
                Config.exitPosition.teleport((Player)player);
            });
            this.board.cleanup();
        }
        if (this.disguiser != null) {
            this.disguiser.cleanUp();
        }
        Bukkit.getServer().getMessenger().unregisterOutgoingPluginChannel((Plugin)this);
    }

    private void onTick() {
        if (this.game.getStatus() == dev.tylerm.khs.game.util.Status.ENDED) {
            this.game = new Game(this.game.getCurrentMap(), this.board);
        }
        this.game.onTick();
        this.disguiser.check();
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new BlockedCommandHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DamageHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new DisguiseHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InteractHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InventoryHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinLeaveHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MovementHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RespawnHandler(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldInteractHandler(), (Plugin)this);
    }

    private void updateVersion() {
        Matcher matcher = Pattern.compile("MC: \\d\\.(\\d+).(\\d+)").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            version = Integer.parseInt(matcher.group(1));
            sub_version = Integer.parseInt(matcher.group(2));
            this.getLogger().info("Identified server version: " + version);
            this.getLogger().info("Identified server sub version: " + sub_version);
            return;
        }
        matcher = Pattern.compile("MC: \\d\\.(\\d+)").matcher(Bukkit.getVersion());
        if (matcher.find()) {
            version = Integer.parseInt(matcher.group(1));
            sub_version = 0;
            this.getLogger().info("Identified server version: " + version);
            return;
        }
        throw new IllegalArgumentException("Failed to parse server version from: " + Bukkit.getVersion());
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_PLAYER_ONLY"));
            return true;
        }
        this.commandGroup.handleCommand((Player)sender, args);
        return true;
    }

    public java.util.List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_PLAYER_ONLY"));
            return new ArrayList<String>();
        }
        return this.commandGroup.handleTabComplete((Player)sender, args);
    }

    public static Main getInstance() {
        return instance;
    }

    public File getWorldContainer() {
        return this.getServer().getWorldContainer();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Board getBoard() {
        return this.board;
    }

    public Game getGame() {
        return this.game;
    }

    public Disguiser getDisguiser() {
        return this.disguiser;
    }

    public EntityHider getEntityHider() {
        return this.entityHider;
    }

    public CommandGroup getCommandGroup() {
        return this.commandGroup;
    }

    public boolean supports(int v) {
        return version >= v;
    }

    public boolean supports(int v, int s) {
        return version == v ? sub_version >= s : version >= v;
    }

    public java.util.List<String> getWorlds() {
        ArrayList<String> worlds = new ArrayList<String>();
        File[] containers = this.getWorldContainer().listFiles();
        if (containers != null) {
            Arrays.stream(containers).forEach(file -> {
                if (!file.isDirectory()) {
                    return;
                }
                String[] files = file.list();
                if (files == null) {
                    return;
                }
                if (!Arrays.asList(files).contains("session.lock") && !Arrays.asList(files).contains("level.dat")) {
                    return;
                }
                worlds.add(file.getName());
            });
        }
        return worlds;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void scheduleTask(Runnable task) {
        if (!this.isEnabled()) {
            return;
        }
        Bukkit.getServer().getScheduler().runTask((Plugin)this, task);
    }
}

