/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.util.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import java.util.ArrayList;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.util.packet.AbstractPacket;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class EntityMetadataPacket
extends AbstractPacket {
    private final WrappedDataWatcher watcher = new WrappedDataWatcher();
    private final WrappedDataWatcher.Serializer serializer = WrappedDataWatcher.Registry.get(Byte.class);

    public EntityMetadataPacket() {
        super(PacketType.Play.Server.ENTITY_METADATA);
    }

    public void setEntity(@NotNull Entity target) {
        this.packet.getIntegers().write(0, (Object)target.getEntityId());
        this.watcher.setEntity(target);
    }

    public void setGlow(boolean glowing) {
        if (glowing) {
            this.watcher.setObject(0, this.serializer, (Object)64);
        } else {
            this.watcher.setObject(0, this.serializer, (Object)0);
        }
    }

    public void writeMetadata() {
        if (Main.getInstance().supports(19, 3)) {
            ArrayList<WrappedDataValue> wrappedDataValueList = new ArrayList<WrappedDataValue>();
            for (WrappedWatchableObject entry : this.watcher.getWatchableObjects()) {
                if (entry == null) continue;
                WrappedDataWatcher.WrappedDataWatcherObject watcherObject = entry.getWatcherObject();
                wrappedDataValueList.add(new WrappedDataValue(watcherObject.getIndex(), watcherObject.getSerializer(), entry.getRawValue()));
            }
            this.packet.getDataValueCollectionModifier().write(0, wrappedDataValueList);
        } else {
            this.packet.getWatchableCollectionModifier().write(0, (Object)this.watcher.getWatchableObjects());
        }
    }
}

