/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game.listener;

import net.tylermurphy.dependencies.xseries.XSound;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.game.Board;
import net.tylermurphy.hideAndSeek.game.Game;
import net.tylermurphy.hideAndSeek.game.PlayerLoader;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class DamageHandler
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Board board = Main.getInstance().getBoard();
        Game game = Main.getInstance().getGame();
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        Player attacker = null;
        if (!game.isCurrentMapValid()) {
            return;
        }
        if (event instanceof EntityDamageByEntityEvent) {
            if (((EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
                attacker = (Player)((EntityDamageByEntityEvent)event).getDamager();
            } else if (((EntityDamageByEntityEvent)event).getDamager() instanceof Projectile && ((Projectile)((EntityDamageByEntityEvent)event).getDamager()).getShooter() instanceof Player) {
                attacker = (Player)((Projectile)((EntityDamageByEntityEvent)event).getDamager()).getShooter();
            }
        }
        if (attacker != null) {
            if (board.contains(player) && !board.contains(attacker) || !board.contains(player) && board.contains(attacker)) {
                event.setCancelled(true);
                return;
            }
            if (!board.contains(player) && !board.contains(attacker)) {
                return;
            }
            if (board.onSameTeam(player, attacker) || board.isSpectator(player) || board.isSpectator(attacker)) {
                event.setCancelled(true);
                return;
            }
            if (!Config.pvpEnabled && board.isHider(attacker) && board.isSeeker(player)) {
                event.setCancelled(true);
                return;
            }
        } else {
            if (!board.contains(player)) {
                return;
            }
            if (!Config.pvpEnabled && !Config.allowNaturalCauses && board.contains(player)) {
                event.setCancelled(true);
                return;
            }
        }
        if (board.isSpectator(player)) {
            event.setCancelled(true);
            if (Main.getInstance().supports(18) && player.getLocation().getBlockY() < -64) {
                game.getCurrentMap().getGameSpawn().teleport(player);
            } else if (!Main.getInstance().supports(18) && player.getLocation().getY() < 0.0) {
                game.getCurrentMap().getGameSpawn().teleport(player);
            }
            return;
        }
        if (board.contains(player) && game.getStatus() != Status.PLAYING) {
            event.setCancelled(true);
            return;
        }
        if (Config.pvpEnabled && player.getHealth() - event.getFinalDamage() >= 0.5) {
            return;
        }
        event.setCancelled(true);
        if (Main.getInstance().supports(9)) {
            XSound.ENTITY_PLAYER_DEATH.play((Entity)player, 1.0f, 1.0f);
        } else {
            XSound.ENTITY_PLAYER_HURT.play((Entity)player, 1.0f, 1.0f);
        }
        Main.getInstance().getDisguiser().reveal(player);
        if (Config.delayedRespawn) {
            game.getCurrentMap().getGameSeekerLobby().teleport(player);
            player.sendMessage(Config.messagePrefix + Localization.message("RESPAWN_NOTICE").addAmount(Config.delayedRespawnDelay));
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> {
                if (game.getStatus() == Status.PLAYING) {
                    game.getCurrentMap().getGameSpawn().teleport(player);
                }
            }, (long)Config.delayedRespawnDelay * 20L);
        } else {
            game.getCurrentMap().getGameSpawn().teleport(player);
        }
        board.addDeath(player.getUniqueId());
        if (attacker != null) {
            board.addKill(attacker.getUniqueId());
        }
        if (board.isSeeker(player)) {
            game.broadcastMessage(Localization.message("GAME_PLAYER_DEATH").addPlayer((Entity)player).toString());
        } else if (board.isHider(player)) {
            if (attacker == null) {
                game.broadcastMessage(Localization.message("GAME_PLAYER_FOUND").addPlayer((Entity)player).toString());
            } else {
                game.broadcastMessage(Localization.message("GAME_PLAYER_FOUND_BY").addPlayer((Entity)player).addPlayer((Entity)attacker).toString());
            }
            board.addSeeker(player);
        }
        PlayerLoader.resetPlayer(player, board);
        board.reloadBoardTeams();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Main.getInstance().getDisguiser().reveal(event.getEntity());
    }
}

