/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game.events;

import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import org.bukkit.WorldBorder;

public class Border {
    private int delay;
    private boolean running;
    private final Map map;
    private int currentSize;

    public Border(Map map) {
        this.map = map;
        this.delay = (int)(60.0 * map.getWorldBorderData().getY());
        this.currentSize = (int)map.getWorldBorderData().getX();
    }

    public void update() {
        if (this.delay == 30 && !this.running) {
            Main.getInstance().getGame().broadcastMessage(Config.worldBorderPrefix + Localization.message("WORLDBORDER_WARN"));
        } else if (this.delay == 0) {
            if (this.running) {
                this.delay = (int)(60.0 * this.map.getWorldBorderData().getY());
                this.running = false;
            } else {
                this.decreaseWorldBorder();
            }
        }
        --this.delay;
    }

    private void decreaseWorldBorder() {
        if (this.currentSize == 100) {
            return;
        }
        if (this.map.getGameSpawn().load() == null) {
            return;
        }
        int change = (int)this.map.getWorldBorderData().getZ();
        if (this.currentSize - change < 100) {
            change = this.currentSize - 100;
        }
        this.running = true;
        Main.getInstance().getGame().broadcastMessage(Config.worldBorderPrefix + Localization.message("WORLDBORDER_DECREASING").addAmount(change));
        this.currentSize = (int)((double)this.currentSize - this.map.getWorldBorderData().getZ());
        WorldBorder border = this.map.getGameSpawn().load().getWorldBorder();
        border.setSize(border.getSize() - (double)change, 30L);
        this.delay = 30;
    }

    public void resetWorldBorder() {
        if (this.map.getGameSpawn().load() == null) {
            return;
        }
        WorldBorder border = this.map.getGameSpawn().load().getWorldBorder();
        if (this.map.isWorldBorderEnabled()) {
            border.setSize(this.map.getWorldBorderData().getX());
            border.setCenter(this.map.getWorldBorderPos().getX(), this.map.getWorldBorderPos().getY());
            this.currentSize = (int)this.map.getWorldBorderData().getX();
        } else {
            border.setSize(3.0E7);
            border.setCenter(0.0, 0.0);
        }
        this.delay = (int)(60.0 * this.map.getWorldBorderData().getY());
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean isRunning() {
        return this.running;
    }
}

