/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database.connections;

import java.sql.Connection;
import java.sql.SQLException;
import net.tylermurphy.dependencies.hikari.HikariConfig;
import net.tylermurphy.dependencies.hikari.HikariDataSource;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.database.connections.DatabaseConnection;
import org.mariadb.jdbc.Driver;

public class MySQLConnection
implements DatabaseConnection {
    private final HikariDataSource ds;

    public MySQLConnection() {
        HikariConfig config = new HikariConfig();
        Main.getInstance().getLogger().info("Database host: " + Config.databaseHost);
        Main.getInstance().getLogger().info("Database port: " + Config.databasePort);
        Main.getInstance().getLogger().info("Database user: " + Config.databaseUser);
        Main.getInstance().getLogger().info("Database pass: xxxxxxxxxxx");
        Main.getInstance().getLogger().info("Database name: " + Config.databaseName);
        config.setDriverClassName(Driver.class.getName());
        config.setJdbcUrl("jdbc:mariadb://" + Config.databaseHost + ":" + Config.databasePort + "/" + Config.databaseName.trim());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        config.addDataSourceProperty("user", Config.databaseUser);
        config.addDataSourceProperty("password", Config.databasePass);
        config.addDataSourceProperty("autoCommit", "true");
        config.setAutoCommit(true);
        config.setMaximumPoolSize(20);
        this.ds = new HikariDataSource(config);
    }

    @Override
    public Connection connect() throws SQLException {
        return this.ds.getConnection();
    }
}

