/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.map.set;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.command.location.LocationUtils;
import net.tylermurphy.hideAndSeek.command.location.Locations;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.util.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class Spawn
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        LocationUtils.setLocation(sender, Locations.GAME, args[0], map -> {
            if (map.isWorldBorderEnabled()) {
                Vector vector = new Vector(sender.getLocation().getX(), 0.0, sender.getLocation().getZ());
                if (vector.distance(map.getWorldBorderPos()) > 100.0) {
                    sender.sendMessage(Config.errorPrefix + Localization.message("WORLDBORDER_POSITION"));
                    throw new RuntimeException("World border not enabled or not in valid position!");
                }
            }
            map.setSpawn(Location.from(sender));
            if (!map.isBoundsNotSetup()) {
                Vector boundsMin = map.getBoundsMin();
                Vector boundsMax = map.getBoundsMax();
                if (map.getSpawn().isNotInBounds(boundsMin.getBlockX(), boundsMax.getBlockX(), boundsMin.getBlockZ(), boundsMax.getBlockZ())) {
                    sender.sendMessage(Config.warningPrefix + Localization.message("WARN_MAP_BOUNDS"));
                }
            }
            if (map.getSeekerLobby().getWorld() != null && !map.getSeekerLobby().getWorld().equals(sender.getLocation().getWorld().getName())) {
                sender.sendMessage(Config.warningPrefix + Localization.message("SEEKER_LOBBY_SPAWN_RESET"));
                map.setSeekerLobby(Location.getDefault());
            }
            if (!sender.getLocation().getWorld().getName().equals(map.getSpawnName()) && Config.mapSaveEnabled) {
                map.getWorldLoader().unloadMap();
            }
        });
    }

    @Override
    public String getLabel() {
        return "spawn";
    }

    @Override
    public String getUsage() {
        return "<map>";
    }

    @Override
    public String getDescription() {
        return "Sets the maps game spawn location";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

