/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command.map;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class Save
implements ICommand {
    public static boolean runningBackup = false;

    @Override
    public void execute(final Player sender, String[] args) {
        if (!Config.mapSaveEnabled) {
            sender.sendMessage(Config.errorPrefix + Localization.message("MAPSAVE_DISABLED"));
            return;
        }
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        final Map map = Maps.getMap(args[0]);
        if (map == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
            return;
        }
        if (map.getSpawn().isNotSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("ERROR_GAME_SPAWN"));
            return;
        }
        if (map.isBoundsNotSetup()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("ERROR_MAP_BOUNDS"));
            return;
        }
        sender.sendMessage(Config.messagePrefix + Localization.message("MAPSAVE_START"));
        sender.sendMessage(Config.warningPrefix + Localization.message("MAPSAVE_WARNING"));
        World world = map.getSpawn().load();
        if (world == null) {
            sender.sendMessage(Config.warningPrefix + Localization.message("MAPSAVE_FAIL_WORLD"));
            return;
        }
        world.save();
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                sender.sendMessage(map.getWorldLoader().save());
                runningBackup = false;
            }
        };
        runnable.runTaskAsynchronously((Plugin)Main.getInstance());
        runningBackup = true;
    }

    @Override
    public String getLabel() {
        return "save";
    }

    @Override
    public String getUsage() {
        return "<map>";
    }

    @Override
    public String getDescription() {
        return "Saves the map to its own separate playable map";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

