/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.List;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Items;
import net.tylermurphy.hideAndSeek.configuration.Leaderboard;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Reload
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().getStatus() != Status.STANDBY) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INPROGRESS"));
            return;
        }
        try {
            Config.loadConfig();
            Maps.loadMaps();
            Localization.loadLocalization();
            Items.loadItems();
            Leaderboard.loadLeaderboard();
        }
        catch (Exception e) {
            sender.sendMessage(Config.errorPrefix + Localization.message("CONFIG_ERROR"));
            return;
        }
        sender.sendMessage(Config.messagePrefix + Localization.message("CONFIG_RELOAD"));
    }

    @Override
    public String getLabel() {
        return "reload";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Reloads the config";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return null;
    }
}

