/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game.util;

import net.tylermurphy.dependencies.xseries.XSound;
import net.tylermurphy.dependencies.xseries.messages.ActionBar;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.util.packet.BlockChangePacket;
import net.tylermurphy.hideAndSeek.util.packet.EntityTeleportPacket;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Disguise {
    final Player hider;
    final Material material;
    FallingBlock block;
    AbstractHorse hitBox;
    Location blockLocation;
    boolean solid;
    boolean solidify;
    boolean solidifying;
    static Team hidden;

    public Disguise(Player player, Material material) {
        this.hider = player;
        this.material = material;
        this.solid = false;
        this.respawnFallingBlock();
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 1000000, 0, false, false));
        if (Main.getInstance().supports(9)) {
            hidden.addEntry(player.getName());
        } else {
            this.hider.spigot().setCollidesWithEntities(false);
        }
    }

    public void remove() {
        if (this.block != null) {
            this.block.remove();
        }
        if (this.hitBox != null) {
            if (Main.getInstance().supports(9)) {
                hidden.removeEntry(this.hitBox.getUniqueId().toString());
            }
            this.hitBox.remove();
        }
        if (this.solid) {
            this.sendBlockUpdate(this.blockLocation, Material.AIR);
        }
        this.hider.removePotionEffect(PotionEffectType.INVISIBILITY);
        if (Main.getInstance().supports(9)) {
            hidden.removeEntry(this.hider.getName());
        } else {
            this.hider.spigot().setCollidesWithEntities(true);
        }
    }

    public int getEntityID() {
        if (this.block == null) {
            return -1;
        }
        return this.block.getEntityId();
    }

    public int getHitBoxID() {
        if (this.hitBox == null) {
            return -1;
        }
        return this.hitBox.getEntityId();
    }

    public Player getPlayer() {
        return this.hider;
    }

    public void update() {
        if (this.block == null || this.block.isDead()) {
            if (this.block != null) {
                this.block.remove();
            }
            this.respawnFallingBlock();
        }
        if (this.solidify) {
            if (!this.solid) {
                this.solid = true;
                this.blockLocation = this.hider.getLocation().getBlock().getLocation();
                this.respawnHitbox();
            }
            this.sendBlockUpdate(this.blockLocation, this.material);
        } else if (this.solid) {
            this.solid = false;
            if (Main.getInstance().supports(9)) {
                hidden.removeEntry(this.hitBox.getUniqueId().toString());
            }
            this.hitBox.remove();
            this.hitBox = null;
            this.sendBlockUpdate(this.blockLocation, Material.AIR);
        }
        this.toggleEntityVisibility((Entity)this.block, !this.solid);
        this.teleportEntity((Entity)this.hitBox, true);
        this.teleportEntity((Entity)this.block, this.solid);
    }

    public void setSolidify(boolean value) {
        this.solidify = value;
    }

    private void sendBlockUpdate(Location location, Material material) {
        BlockChangePacket packet = new BlockChangePacket();
        packet.setBlockPosition(location);
        packet.setMaterial(material);
        Bukkit.getOnlinePlayers().forEach(receiver -> {
            if (receiver.getName().equals(this.hider.getName())) {
                return;
            }
            packet.send((Player)receiver);
        });
    }

    private void teleportEntity(Entity entity, boolean center) {
        double z;
        double y;
        double x;
        if (entity == null) {
            return;
        }
        EntityTeleportPacket packet = new EntityTeleportPacket();
        packet.setEntity(entity);
        if (center) {
            x = (double)Math.round(this.hider.getLocation().getX() + 0.5) - 0.5;
            y = Math.round(this.hider.getLocation().getY());
            z = (double)Math.round(this.hider.getLocation().getZ() + 0.5) - 0.5;
        } else {
            x = this.hider.getLocation().getX();
            y = this.hider.getLocation().getY();
            z = this.hider.getLocation().getZ();
        }
        packet.setX(x);
        packet.setY(y);
        packet.setZ(z);
        Bukkit.getOnlinePlayers().forEach(packet::send);
    }

    private void toggleEntityVisibility(Entity entity, boolean show) {
        if (entity == null) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(receiver -> {
            if (receiver == this.hider) {
                return;
            }
            if (show) {
                Main.getInstance().getEntityHider().showEntity((Player)receiver, entity);
            } else {
                Main.getInstance().getEntityHider().hideEntity((Player)receiver, entity);
            }
        });
    }

    private void respawnFallingBlock() {
        this.block = this.hider.getLocation().getWorld().spawnFallingBlock(this.hider.getLocation().add(0.0, 1000.0, 0.0), this.material, (byte)0);
        if (Main.getInstance().supports(10)) {
            this.block.setGravity(false);
        }
        this.block.setDropItem(false);
        this.block.setInvulnerable(true);
    }

    private void respawnHitbox() {
        if (Main.getInstance().supports(11)) {
            this.hitBox = (AbstractHorse)this.hider.getLocation().getWorld().spawnEntity(this.hider.getLocation().add(0.0, 1000.0, 0.0), EntityType.SKELETON_HORSE);
        } else {
            this.hitBox = (AbstractHorse)this.hider.getLocation().getWorld().spawnEntity(this.hider.getLocation().add(0.0, 1000.0, 0.0), EntityType.HORSE);
            this.hitBox.setVariant(Horse.Variant.SKELETON_HORSE);
        }
        if (Main.getInstance().supports(10)) {
            this.hitBox.setGravity(false);
        }
        this.hitBox.setAI(false);
        this.hitBox.setInvulnerable(true);
        this.hitBox.setCanPickupItems(false);
        this.hitBox.setCollidable(false);
        this.hitBox.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 1000000, 0, false, false));
        if (Main.getInstance().supports(9)) {
            hidden.addEntry(this.hitBox.getUniqueId().toString());
        }
    }

    public void startSolidifying() {
        if (this.solidifying) {
            return;
        }
        if (this.solid) {
            return;
        }
        this.solidifying = true;
        Location lastLocation = this.hider.getLocation();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> this.solidifyUpdate(lastLocation, 3), 10L);
    }

    private void solidifyUpdate(Location lastLocation, int time) {
        Location currentLocation = this.hider.getLocation();
        if (lastLocation.getWorld() != currentLocation.getWorld()) {
            this.solidifying = false;
            return;
        }
        if (lastLocation.distance(currentLocation) > 0.1) {
            this.solidifying = false;
            return;
        }
        if (time == 0) {
            ActionBar.clearActionBar(this.hider);
            this.setSolidify(true);
            this.solidifying = false;
        } else {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < time; ++i) {
                s.append("\u25aa");
            }
            ActionBar.sendActionBar(this.hider, s.toString());
            XSound.BLOCK_NOTE_BLOCK_PLING.play((Entity)this.hider, 1.0f, 1.0f);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Main.getInstance(), () -> this.solidifyUpdate(lastLocation, time - 1), 20L);
        }
    }

    static {
        if (Main.getInstance().supports(9)) {
            Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
            hidden = board.getTeam("KHS_Collision");
            if (hidden == null) {
                hidden = board.registerNewTeam("KHS_Collision");
            }
            hidden.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            hidden.setCanSeeFriendlyInvisibles(false);
        }
    }
}

