/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;

public class EntityHider
implements Listener {
    protected Table<Integer, Integer, Boolean> observerEntityMap = HashBasedTable.create();
    private static final PacketType[] ENTITY_PACKETS = new PacketType[]{PacketType.Play.Server.ENTITY_EQUIPMENT, PacketType.Play.Server.ANIMATION, PacketType.Play.Server.NAMED_ENTITY_SPAWN, PacketType.Play.Server.COLLECT, PacketType.Play.Server.SPAWN_ENTITY, PacketType.Play.Server.SPAWN_ENTITY_EXPERIENCE_ORB, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.REL_ENTITY_MOVE, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.ENTITY_HEAD_ROTATION, PacketType.Play.Server.ENTITY_STATUS, PacketType.Play.Server.ATTACH_ENTITY, PacketType.Play.Server.ENTITY_METADATA, PacketType.Play.Server.ENTITY_EFFECT, PacketType.Play.Server.REMOVE_ENTITY_EFFECT, PacketType.Play.Server.BLOCK_BREAK_ANIMATION};
    private ProtocolManager manager;
    private final Listener bukkitListener;
    private final PacketAdapter protocolListener;
    protected final Policy policy;

    public EntityHider(Plugin plugin, Policy policy) {
        Preconditions.checkNotNull((Object)plugin, (Object)"plugin cannot be NULL.");
        this.policy = policy;
        this.manager = ProtocolLibrary.getProtocolManager();
        this.bukkitListener = this.constructBukkit();
        plugin.getServer().getPluginManager().registerEvents(this.bukkitListener, plugin);
        this.protocolListener = this.constructProtocol(plugin);
        this.manager.addPacketListener((PacketListener)this.protocolListener);
    }

    protected boolean setVisibility(Player observer, int entityID, boolean visible) {
        switch (this.policy) {
            case BLACKLIST: {
                return !this.setMembership(observer, entityID, !visible);
            }
            case WHITELIST: {
                return this.setMembership(observer, entityID, visible);
            }
        }
        throw new IllegalArgumentException("Unknown policy: " + (Object)((Object)this.policy));
    }

    protected boolean setMembership(Player observer, int newEntityId, boolean member) {
        int entityID;
        try {
            entityID = observer.getEntityId();
        }
        catch (Exception e) {
            return member;
        }
        if (member) {
            return this.observerEntityMap.put((Object)newEntityId, (Object)entityID, (Object)true) != null;
        }
        return this.observerEntityMap.remove((Object)newEntityId, (Object)entityID) != null;
    }

    protected boolean getMembership(Player observer, int newEntityID) {
        int entityID;
        try {
            entityID = observer.getEntityId();
        }
        catch (Exception e) {
            return false;
        }
        return this.observerEntityMap.contains((Object)entityID, (Object)newEntityID);
    }

    protected boolean isVisible(Player observer, int entityID) {
        boolean presence = this.getMembership(observer, entityID);
        return this.policy == Policy.WHITELIST == presence;
    }

    protected void removeEntity(Entity entity) {
        int entityID;
        try {
            entityID = entity.getEntityId();
        }
        catch (Exception e) {
            return;
        }
        for (Map maps : this.observerEntityMap.rowMap().values()) {
            maps.remove(entityID);
        }
    }

    protected void removePlayer(Player player) {
        int entityID;
        try {
            entityID = player.getEntityId();
        }
        catch (Exception e) {
            return;
        }
        this.observerEntityMap.rowMap().remove(entityID);
    }

    private Listener constructBukkit() {
        return new Listener(){

            @EventHandler
            public void onEntityDeath(EntityDeathEvent e) {
                EntityHider.this.removeEntity((Entity)e.getEntity());
            }

            @EventHandler
            public void onChunkUnload(ChunkUnloadEvent e) {
                for (Entity entity : e.getChunk().getEntities()) {
                    EntityHider.this.removeEntity(entity);
                }
            }

            @EventHandler
            public void onPlayerQuit(PlayerQuitEvent e) {
                EntityHider.this.removePlayer(e.getPlayer());
            }
        };
    }

    private PacketAdapter constructProtocol(Plugin plugin) {
        return new PacketAdapter(plugin, ENTITY_PACKETS){

            public void onPacketSending(PacketEvent event) {
                int entityID = (Integer)event.getPacket().getIntegers().read(0);
                if (!EntityHider.this.isVisible(event.getPlayer(), entityID)) {
                    event.setCancelled(true);
                }
            }
        };
    }

    public final boolean toggleEntity(Player observer, Entity entity) {
        int entityID;
        try {
            entityID = observer.getEntityId();
        }
        catch (Exception e) {
            return true;
        }
        if (this.isVisible(observer, entityID)) {
            return this.hideEntity(observer, entity);
        }
        return !this.showEntity(observer, entity);
    }

    public final boolean showEntity(Player observer, Entity entity) {
        boolean hiddenBefore;
        int entityID;
        this.validate(observer, entity);
        try {
            entityID = entity.getEntityId();
        }
        catch (Exception e) {
            return false;
        }
        boolean bl = hiddenBefore = !this.setVisibility(observer, entityID, true);
        if (this.manager != null && hiddenBefore) {
            this.manager.updateEntity(entity, Collections.singletonList(observer));
        }
        return hiddenBefore;
    }

    public final boolean hideEntity(Player observer, Entity entity) {
        int entityID;
        this.validate(observer, entity);
        try {
            entityID = entity.getEntityId();
        }
        catch (Exception e) {
            return true;
        }
        boolean visibleBefore = this.setVisibility(observer, entityID, false);
        if (visibleBefore) {
            PacketContainer destroyEntity = new PacketContainer(PacketType.Play.Server.ENTITY_DESTROY);
            try {
                destroyEntity.getIntegerArrays().write(0, (Object)new int[]{entityID});
            }
            catch (Exception e) {
                return false;
            }
            this.manager.sendServerPacket(observer, destroyEntity);
        }
        return visibleBefore;
    }

    public final boolean canSee(Player observer, Entity entity) {
        int entityID;
        this.validate(observer, entity);
        try {
            entityID = entity.getEntityId();
        }
        catch (Exception e) {
            return true;
        }
        return this.isVisible(observer, entityID);
    }

    private void validate(Player observer, Entity entity) {
        Preconditions.checkNotNull((Object)observer, (Object)"observer cannot be NULL.");
        Preconditions.checkNotNull((Object)entity, (Object)"entity cannot be NULL.");
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void close() {
        if (this.manager != null) {
            HandlerList.unregisterAll((Listener)this.bukkitListener);
            this.manager.removePacketListener((PacketListener)this.protocolListener);
            this.manager = null;
        }
    }

    public static enum Policy {
        WHITELIST,
        BLACKLIST;

    }
}

