/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.game;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Leaderboard;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.game.CustomBoard;
import net.tylermurphy.hideAndSeek.game.events.Border;
import net.tylermurphy.hideAndSeek.game.events.Glow;
import net.tylermurphy.hideAndSeek.game.events.Taunt;
import net.tylermurphy.hideAndSeek.game.util.Status;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.ScoreboardManager;

public class Board {
    private UUID initialSeeker = null;
    private final java.util.Map<UUID, Type> Players = new HashMap<UUID, Type>();
    private final java.util.Map<UUID, CustomBoard> customBoards = new HashMap<UUID, CustomBoard>();
    private final java.util.Map<UUID, Integer> hider_kills = new HashMap<UUID, Integer>();
    private final java.util.Map<UUID, Integer> seeker_kills = new HashMap<UUID, Integer>();
    private final java.util.Map<UUID, Integer> hider_deaths = new HashMap<UUID, Integer>();
    private final java.util.Map<UUID, Integer> seeker_deaths = new HashMap<UUID, Integer>();

    public boolean contains(Player player) {
        return this.Players.containsKey(player.getUniqueId());
    }

    public boolean isHider(Player player) {
        return this.isHider(player.getUniqueId());
    }

    public boolean isHider(UUID uuid) {
        if (!this.Players.containsKey(uuid)) {
            return false;
        }
        return this.Players.get(uuid) == Type.HIDER;
    }

    public boolean isSeeker(Player player) {
        return this.isSeeker(player.getUniqueId());
    }

    public boolean isSeeker(UUID uuid) {
        if (!this.Players.containsKey(uuid)) {
            return false;
        }
        return this.Players.get(uuid) == Type.SEEKER;
    }

    public boolean isSpectator(Player player) {
        return this.isSpectator(player.getUniqueId());
    }

    public boolean isSpectator(UUID uuid) {
        if (!this.Players.containsKey(uuid)) {
            return false;
        }
        return this.Players.get(uuid) == Type.SPECTATOR;
    }

    public int sizeHider() {
        return this.getHiders().size();
    }

    public int sizeSeeker() {
        return this.getSeekers().size();
    }

    public int size() {
        return this.getPlayers().size();
    }

    public List<Player> getHiders() {
        return this.Players.keySet().stream().filter(s -> this.Players.get(s) == Type.HIDER).map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Player> getSeekers() {
        return this.Players.keySet().stream().filter(s -> this.Players.get(s) == Type.SEEKER).map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Player> getSpectators() {
        return this.Players.keySet().stream().filter(s -> this.Players.get(s) == Type.SPECTATOR).map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Player> getPlayers() {
        return this.Players.keySet().stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Player getFirstSeeker() {
        if (this.initialSeeker == null) {
            return null;
        }
        return Bukkit.getPlayer((UUID)this.initialSeeker);
    }

    public Player getPlayer(UUID uuid) {
        if (!this.Players.containsKey(uuid)) {
            return null;
        }
        return Bukkit.getPlayer((UUID)uuid);
    }

    public void addHider(Player player) {
        this.Players.put(player.getUniqueId(), Type.HIDER);
    }

    public void addSeeker(Player player) {
        if (this.initialSeeker == null) {
            this.initialSeeker = player.getUniqueId();
        }
        this.Players.put(player.getUniqueId(), Type.SEEKER);
    }

    public void addSpectator(Player player) {
        this.Players.put(player.getUniqueId(), Type.SPECTATOR);
    }

    public void remove(Player player) {
        this.Players.remove(player.getUniqueId());
    }

    public boolean onSameTeam(Player player1, Player player2) {
        return this.Players.get(player1.getUniqueId()) == this.Players.get(player2.getUniqueId());
    }

    public void reload() {
        this.Players.replaceAll((u, v) -> Type.HIDER);
        this.hider_kills.clear();
        this.seeker_kills.clear();
        this.hider_deaths.clear();
        this.seeker_deaths.clear();
    }

    public void addKill(UUID uuid) {
        if (this.Players.get(uuid) == Type.HIDER) {
            int kills = this.hider_kills.getOrDefault(uuid, 0);
            this.hider_kills.put(uuid, kills + 1);
        } else if (this.Players.get(uuid) == Type.SEEKER) {
            int kills = this.seeker_kills.getOrDefault(uuid, 0);
            this.seeker_kills.put(uuid, kills + 1);
        }
    }

    public void addDeath(UUID uuid) {
        if (this.Players.get(uuid) == Type.HIDER) {
            int kills = this.hider_deaths.getOrDefault(uuid, 0);
            this.hider_deaths.put(uuid, kills + 1);
        } else if (this.Players.get(uuid) == Type.SEEKER) {
            int kills = this.seeker_deaths.getOrDefault(uuid, 0);
            this.seeker_deaths.put(uuid, kills + 1);
        }
    }

    public java.util.Map<UUID, Integer> getHiderKills() {
        return new HashMap<UUID, Integer>(this.hider_kills);
    }

    public java.util.Map<UUID, Integer> getSeekerKills() {
        return new HashMap<UUID, Integer>(this.seeker_kills);
    }

    public java.util.Map<UUID, Integer> getHiderDeaths() {
        return new HashMap<UUID, Integer>(this.hider_deaths);
    }

    public java.util.Map<UUID, Integer> getSeekerDeaths() {
        return new HashMap<UUID, Integer>(this.seeker_deaths);
    }

    public void createLobbyBoard(Player player) {
        this.createLobbyBoard(player, true);
    }

    private void createLobbyBoard(Player player, boolean recreate) {
        CustomBoard board = this.customBoards.get(player.getUniqueId());
        if (recreate || board == null) {
            board = new CustomBoard(player, Leaderboard.LOBBY_TITLE);
            board.updateTeams();
        }
        int i = 0;
        for (String line : Leaderboard.LOBBY_CONTENTS) {
            if (line.equalsIgnoreCase("")) {
                board.addBlank();
            } else if (line.contains("{COUNTDOWN}")) {
                if (!Config.lobbyCountdownEnabled) {
                    board.setLine(String.valueOf(i), line.replace("{COUNTDOWN}", Leaderboard.COUNTDOWN_ADMINSTART));
                } else if (Main.getInstance().getGame().getLobbyTime() == -1) {
                    board.setLine(String.valueOf(i), line.replace("{COUNTDOWN}", Leaderboard.COUNTDOWN_WAITING));
                } else {
                    board.setLine(String.valueOf(i), line.replace("{COUNTDOWN}", Leaderboard.COUNTDOWN_COUNTING.replace("{AMOUNT}", Main.getInstance().getGame().getLobbyTime() + "")));
                }
            } else if (line.contains("{COUNT}")) {
                board.setLine(String.valueOf(i), line.replace("{COUNT}", this.getPlayers().size() + ""));
            } else if (line.contains("{SEEKER%}")) {
                board.setLine(String.valueOf(i), line.replace("{SEEKER%}", this.getSeekerPercent() + ""));
            } else if (line.contains("{HIDER%}")) {
                board.setLine(String.valueOf(i), line.replace("{HIDER%}", this.getHiderPercent() + ""));
            } else if (line.contains("{MAP}")) {
                board.setLine(String.valueOf(i), line.replace("{MAP}", this.getMapName() + ""));
            } else {
                board.setLine(String.valueOf(i), line);
            }
            ++i;
        }
        board.display();
        this.customBoards.put(player.getUniqueId(), board);
    }

    public String getMapName() {
        Map map = Main.getInstance().getGame().getCurrentMap();
        if (map == null) {
            return "Invalid";
        }
        return map.getName();
    }

    public void createGameBoard(Player player) {
        this.createGameBoard(player, true);
    }

    private void createGameBoard(Player player, boolean recreate) {
        CustomBoard board = this.customBoards.get(player.getUniqueId());
        if (recreate || board == null) {
            board = new CustomBoard(player, Leaderboard.GAME_TITLE);
            board.updateTeams();
        }
        int timeLeft = Main.getInstance().getGame().getTimeLeft();
        Status status = Main.getInstance().getGame().getStatus();
        Taunt taunt = Main.getInstance().getGame().getTaunt();
        Border worldBorder = Main.getInstance().getGame().getCurrentMap().getWorldBorder();
        Glow glow = Main.getInstance().getGame().getGlow();
        int i = 0;
        for (String line : Leaderboard.GAME_CONTENTS) {
            String value;
            if (line.equalsIgnoreCase("")) {
                board.addBlank();
            } else if (line.contains("{TIME}")) {
                value = timeLeft / 60 + "m" + timeLeft % 60 + "s";
                board.setLine(String.valueOf(i), line.replace("{TIME}", value));
            } else if (line.contains("{TEAM}")) {
                value = this.getTeam(player);
                board.setLine(String.valueOf(i), line.replace("{TEAM}", value));
            } else if (line.contains("{BORDER}")) {
                if (!Main.getInstance().getGame().getCurrentMap().isWorldBorderEnabled()) continue;
                if (status == Status.STARTING) {
                    board.setLine(String.valueOf(i), line.replace("{BORDER}", Leaderboard.BORDER_COUNTING.replace("{AMOUNT}", "0")));
                } else if (!worldBorder.isRunning()) {
                    board.setLine(String.valueOf(i), line.replace("{BORDER}", Leaderboard.BORDER_COUNTING.replaceFirst("\\{AMOUNT}", worldBorder.getDelay() / 60 + "").replaceFirst("\\{AMOUNT}", worldBorder.getDelay() % 60 + "")));
                } else {
                    board.setLine(String.valueOf(i), line.replace("{BORDER}", Leaderboard.BORDER_DECREASING));
                }
            } else if (line.contains("{TAUNT}")) {
                if (!Config.tauntEnabled) continue;
                if (taunt == null || status == Status.STARTING) {
                    board.setLine(String.valueOf(i), line.replace("{TAUNT}", Leaderboard.TAUNT_COUNTING.replace("{AMOUNT}", "0")));
                } else if (!Config.tauntLast && this.sizeHider() == 1) {
                    board.setLine(String.valueOf(i), line.replace("{TAUNT}", Leaderboard.TAUNT_EXPIRED));
                } else if (!taunt.isRunning()) {
                    board.setLine(String.valueOf(i), line.replace("{TAUNT}", Leaderboard.TAUNT_COUNTING.replaceFirst("\\{AMOUNT}", taunt.getDelay() / 60 + "").replaceFirst("\\{AMOUNT}", taunt.getDelay() % 60 + "")));
                } else {
                    board.setLine(String.valueOf(i), line.replace("{TAUNT}", Leaderboard.TAUNT_ACTIVE));
                }
            } else if (line.contains("{GLOW}")) {
                if (!Config.glowEnabled) continue;
                if (glow == null || status == Status.STARTING || !glow.isRunning()) {
                    board.setLine(String.valueOf(i), line.replace("{GLOW}", Leaderboard.GLOW_INACTIVE));
                } else {
                    board.setLine(String.valueOf(i), line.replace("{GLOW}", Leaderboard.GLOW_ACTIVE));
                }
            } else if (line.contains("{#SEEKER}")) {
                board.setLine(String.valueOf(i), line.replace("{#SEEKER}", this.getSeekers().size() + ""));
            } else if (line.contains("{#HIDER}")) {
                board.setLine(String.valueOf(i), line.replace("{#HIDER}", this.getHiders().size() + ""));
            } else if (line.contains("{MAP}")) {
                board.setLine(String.valueOf(i), line.replace("{MAP}", this.getMapName() + ""));
            } else {
                board.setLine(String.valueOf(i), line);
            }
            ++i;
        }
        board.display();
        this.customBoards.put(player.getUniqueId(), board);
    }

    public void removeBoard(Player player) {
        ScoreboardManager manager = Bukkit.getScoreboardManager();
        assert (manager != null);
        player.setScoreboard(manager.getMainScoreboard());
        this.customBoards.remove(player.getUniqueId());
    }

    public void reloadLobbyBoards() {
        for (Player player : this.getPlayers()) {
            this.createLobbyBoard(player, false);
        }
    }

    public void reloadGameBoards() {
        for (Player player : this.getPlayers()) {
            this.createGameBoard(player, false);
        }
    }

    public void reloadBoardTeams() {
        for (CustomBoard board : this.customBoards.values()) {
            board.updateTeams();
        }
    }

    private String getSeekerPercent() {
        int size = this.size();
        if (size < 2) {
            return " --";
        }
        return " " + (int)(100.0 * (1.0 / (double)size));
    }

    private String getHiderPercent() {
        int size = this.size();
        if (size < 2) {
            return " --";
        }
        return " " + (int)(100.0 - 100.0 * (1.0 / (double)size));
    }

    private String getTeam(Player player) {
        if (this.isHider(player)) {
            return Localization.message("HIDER_TEAM_NAME").toString();
        }
        if (this.isSeeker(player)) {
            return Localization.message("SEEKER_TEAM_NAME").toString();
        }
        if (this.isSpectator(player)) {
            return Localization.message("SPECTATOR_TEAM_NAME").toString();
        }
        return ChatColor.WHITE + "UNKNOWN";
    }

    public void cleanup() {
        this.Players.clear();
        this.initialSeeker = null;
        this.customBoards.clear();
    }

    private static enum Type {
        HIDER,
        SEEKER,
        SPECTATOR;

    }
}

