/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import net.tylermurphy.hideAndSeek.database.Database;
import net.tylermurphy.hideAndSeek.database.util.LegacyPlayerInfo;

public class LegacyTable {
    private final Database database;
    private final boolean exists;

    protected LegacyTable(Database database) {
        boolean check;
        String sql = "SELECT * FROM player_info LIMIT 1;";
        try (Connection connection = database.connect();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            check = resultSet.next();
        }
        catch (SQLException e) {
            check = false;
        }
        this.exists = check;
        this.database = database;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean copyData() {
        String sql = "SELECT * FROM player_info;";
        ArrayList<LegacyPlayerInfo> legacyPlayerInfoList = new ArrayList<LegacyPlayerInfo>();
        try (Connection connection = this.database.connect();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                legacyPlayerInfoList.add(new LegacyPlayerInfo(resultSet.getBytes("uuid"), resultSet.getInt("hider_wins"), resultSet.getInt("seeker_wins"), resultSet.getInt("games_played")));
            }
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        for (LegacyPlayerInfo legacyInfo : legacyPlayerInfoList) {
            this.database.getGameData().updateInfo(legacyInfo.getUniqueId(), legacyInfo.getHiderWins(), legacyInfo.getSeekerWins(), legacyInfo.getGamesPlayer() - legacyInfo.getSeekerWins(), legacyInfo.getSeekerWins(), 0, 0, 0, 0);
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean drop() {
        String sql = "DROP table player_info";
        try (Connection connection = this.database.connect();){
            boolean bl;
            block14: {
                Statement statement = connection.createStatement();
                try {
                    statement.execute(sql);
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }
}

