/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.tylermurphy.dependencies.xseries.XMaterial;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.configuration.ConfigManager;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.util.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Maps {
    private static final HashMap<String, Map> MAPS = new HashMap();

    @Nullable
    public static Map getMap(String name) {
        return MAPS.get(name);
    }

    @Nullable
    public static Map getRandomMap() {
        Optional<Object> map;
        if (MAPS.values().size() > 0) {
            Collection setupMaps = MAPS.values().stream().filter(m -> !m.isNotSetup()).collect(Collectors.toList());
            if (setupMaps.size() < 1) {
                return null;
            }
            map = setupMaps.stream().skip(new Random().nextInt(setupMaps.size())).findFirst();
        } else {
            map = Optional.empty();
        }
        return map.orElse(null);
    }

    public static void setMap(String name, Map map) {
        MAPS.put(name, map);
        Maps.saveMaps();
    }

    public static boolean removeMap(String name) {
        boolean status = MAPS.remove(name) != null;
        Maps.saveMaps();
        return status;
    }

    @NotNull
    public static Collection<Map> getAllMaps() {
        return MAPS.values();
    }

    public static void loadMaps() {
        ConfigManager manager = ConfigManager.create("maps.yml");
        ConfigurationSection maps = manager.getConfigurationSection("maps");
        if (maps == null) {
            return;
        }
        Set keys = maps.getKeys(false);
        if (keys == null) {
            return;
        }
        MAPS.clear();
        for (String key : keys) {
            MAPS.put(key, Maps.parseMap(maps, key));
        }
    }

    private static Map parseMap(ConfigurationSection maps, String name) {
        ConfigurationSection data = maps.getConfigurationSection(name);
        if (data == null) {
            return null;
        }
        Map map = new Map(name);
        Main.getInstance().getLogger().info("Loading map: " + name + "...");
        map.setSpawn(Maps.getSpawn(data, "game"));
        map.setLobby(Maps.getSpawn(data, "lobby"));
        map.setSeekerLobby(Maps.getSpawn(data, "seeker"));
        map.setBoundMin(data.getInt("bounds.min.x"), data.getInt("bounds.min.z"));
        map.setBoundMax(data.getInt("bounds.max.x"), data.getInt("bounds.max.z"));
        map.setWorldBorderData(data.getInt("worldborder.pos.x"), data.getInt("worldborder.pos.z"), data.getInt("worldborder.size"), data.getInt("worldborder.delay"), data.getInt("worldborder.change"));
        ArrayList blockhunt = data.getStringList("blockhunt.blocks");
        if (blockhunt == null) {
            blockhunt = new ArrayList();
        }
        map.setBlockhunt(data.getBoolean("blockhunt.enabled"), blockhunt.stream().map(XMaterial::matchXMaterial).filter(Optional::isPresent).map(e -> ((XMaterial)((Object)((Object)e.get()))).parseMaterial()).filter(Objects::nonNull).collect(Collectors.toList()));
        return map;
    }

    private static Location getSpawn(ConfigurationSection data, String spawn) {
        String world = data.getString("spawns." + spawn + ".world");
        double x = data.getDouble("spawns." + spawn + ".x");
        double y = data.getDouble("spawns." + spawn + ".y");
        double z = data.getDouble("spawns." + spawn + ".z");
        return new Location(world, x, y, z);
    }

    private static void saveMaps() {
        ConfigManager manager = ConfigManager.create("maps.yml");
        YamlConfiguration maps = new YamlConfiguration();
        for (Map map : MAPS.values()) {
            YamlConfiguration data = new YamlConfiguration();
            Maps.saveSpawn((ConfigurationSection)data, map.getSpawn(), "game", map);
            Maps.saveSpawn((ConfigurationSection)data, map.getLobby(), "lobby", map);
            Maps.saveSpawn((ConfigurationSection)data, map.getSeekerLobby(), "seeker", map);
            data.set("bounds.min.x", (Object)map.getBoundsMin().getX());
            data.set("bounds.min.z", (Object)map.getBoundsMin().getZ());
            data.set("bounds.max.x", (Object)map.getBoundsMax().getX());
            data.set("bounds.max.z", (Object)map.getBoundsMax().getZ());
            data.set("worldborder.pos.x", (Object)map.getWorldBorderPos().getX());
            data.set("worldborder.pos.z", (Object)map.getWorldBorderPos().getZ());
            data.set("worldborder.pos.size", (Object)map.getWorldBorderData().getX());
            data.set("worldborder.pos.delay", (Object)map.getWorldBorderData().getY());
            data.set("worldborder.pos.change", (Object)map.getWorldBorderData().getZ());
            data.set("blockhunt.enabled", (Object)map.isBlockHuntEnabled());
            data.set("blockhunt.blocks", map.getBlockHunt().stream().map(Enum::name).collect(Collectors.toList()));
            maps.set(map.getName(), (Object)data);
        }
        manager.set("maps", maps);
        manager.overwriteConfig();
    }

    private static void saveSpawn(ConfigurationSection data, Location spawn, String name, Map map) {
        String worldName = Maps.getWorldName(name, map);
        data.set("spawns." + name + ".world", (Object)worldName);
        data.set("spawns." + name + ".x", (Object)spawn.getX());
        data.set("spawns." + name + ".y", (Object)spawn.getY());
        data.set("spawns." + name + ".z", (Object)spawn.getZ());
    }

    private static String getWorldName(String name, Map map) {
        switch (name) {
            case "game": {
                return map.getSpawnName();
            }
            case "lobby": {
                return map.getLobbyName();
            }
            case "seeker": {
                return map.getSeekerLobbyName();
            }
        }
        return null;
    }
}

