/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.List;
import java.util.stream.Collectors;
import net.tylermurphy.hideAndSeek.Main;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import net.tylermurphy.hideAndSeek.configuration.Map;
import net.tylermurphy.hideAndSeek.configuration.Maps;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Join
implements ICommand {
    @Override
    public void execute(Player sender, String[] args) {
        if (Main.getInstance().getGame().checkCurrentMap()) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_SETUP"));
            return;
        }
        Player player = Bukkit.getServer().getPlayer(sender.getName());
        if (player == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("COMMAND_ERROR"));
            return;
        }
        if (Main.getInstance().getBoard().contains(player)) {
            sender.sendMessage(Config.errorPrefix + Localization.message("GAME_INGAME"));
            return;
        }
        if (args.length > 0) {
            if (Main.getInstance().getBoard().size() > 0) {
                sender.sendMessage(Config.errorPrefix + Localization.message("LOBBY_IN_USE"));
                return;
            }
            Map map = Maps.getMap(args[0]);
            if (map == null) {
                sender.sendMessage(Config.errorPrefix + Localization.message("INVALID_MAP"));
                return;
            }
            Main.getInstance().getGame().setCurrentMap(map);
        }
        Main.getInstance().getGame().join(player);
    }

    @Override
    public String getLabel() {
        return "join";
    }

    @Override
    public String getUsage() {
        return "<*map>";
    }

    @Override
    public String getDescription() {
        return "Joins the lobby if game is set to manual join/leave";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        if (parameter.equals("*map")) {
            return Maps.getAllMaps().stream().map(Map::getName).collect(Collectors.toList());
        }
        return null;
    }
}

