/*
 * Decompiled with CFR 0.152.
 */
package net.tylermurphy.hideAndSeek.command;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.tylermurphy.hideAndSeek.command.util.ICommand;
import net.tylermurphy.hideAndSeek.configuration.Config;
import net.tylermurphy.hideAndSeek.configuration.Localization;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Confirm
implements ICommand {
    public static final Map<UUID, Confirmation> confirmations = new HashMap<UUID, Confirmation>();

    @Override
    public void execute(Player sender, String[] args) {
        Confirmation confirmation = confirmations.get(sender.getUniqueId());
        confirmations.remove(sender.getUniqueId());
        if (confirmation == null) {
            sender.sendMessage(Config.errorPrefix + Localization.message("NO_CONFIRMATION"));
        } else {
            long now = System.currentTimeMillis();
            float secs = (float)(now - confirmation.start) / 1000.0f;
            if (secs > 10.0f) {
                sender.sendMessage(Config.errorPrefix + Localization.message("CONFIRMATION_TIMED_OUT"));
                return;
            }
            confirmation.callback.accept(confirmation.data);
        }
    }

    @Override
    public String getLabel() {
        return "confirm";
    }

    @Override
    public String getUsage() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Confirm another command if required";
    }

    @Override
    public List<String> autoComplete(@NotNull String parameter, @NotNull String typed) {
        return null;
    }

    public static class Confirmation {
        public final Consumer<String> callback;
        public final String data;
        public final long start;

        public Confirmation(String data, Consumer<String> callback) {
            this.callback = callback;
            this.data = data;
            this.start = System.currentTimeMillis();
        }
    }
}

